/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.api.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import refinedstorage.api.RefinedStorageAPI;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.autocrafting.task.ICraftingTask;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.storage.CompareUtils;

public final class NetworkUtils {
    public static ItemStack extractItem(INetworkMaster network, ItemStack stack, int size) {
        return network.extractItem(stack, size, 3);
    }

    public static FluidStack extractFluid(INetworkMaster network, FluidStack stack, int size) {
        return network.extractFluid(stack, size, 2);
    }

    public static ICraftingPattern getPattern(INetworkMaster network, ItemStack stack) {
        return network.getPattern(stack, 3);
    }

    public static ICraftingTask createCraftingTask(INetworkMaster network, ICraftingPattern pattern) {
        return RefinedStorageAPI.instance().getCraftingTaskRegistry().getFactory(pattern.getId()).create(network.getNetworkWorld(), null, pattern);
    }

    public static boolean hasPattern(INetworkMaster network, ItemStack stack) {
        return NetworkUtils.getPattern(network, stack) != null;
    }

    public static void rebuildGraph(INetworkMaster network) {
        network.getNodeGraph().rebuild(network.getPosition(), true);
    }

    public static int getItemStackHashCode(ItemStack stack) {
        return stack.func_77973_b().hashCode() * (stack.func_77952_i() + 1) * (stack.func_77942_o() ? stack.func_77978_p().hashCode() : 1);
    }

    public static int getFluidStackHashCode(FluidStack stack) {
        return stack.getFluid().hashCode() * (stack.tag != null ? stack.tag.hashCode() : 1);
    }

    public static void scheduleCraftingTaskIfUnscheduled(INetworkMaster network, ItemStack stack, int toSchedule, int compare) {
        int alreadyScheduled = 0;
        for (ICraftingTask task : network.getCraftingTasks()) {
            for (ItemStack output : task.getPattern().getOutputs()) {
                if (!CompareUtils.compareStack(output, stack, compare)) continue;
                ++alreadyScheduled;
            }
        }
        for (int i = 0; i < toSchedule - alreadyScheduled; ++i) {
            ICraftingPattern pattern = network.getPattern(stack, compare);
            if (pattern == null) continue;
            network.addCraftingTask(NetworkUtils.createCraftingTask(network, pattern));
        }
    }

    public static void writeItemStack(ByteBuf buf, INetworkMaster network, ItemStack stack) {
        buf.writeInt(Item.func_150891_b((Item)stack.func_77973_b()));
        buf.writeInt(stack.field_77994_a);
        buf.writeInt(stack.func_77952_i());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.func_77978_p());
        buf.writeInt(NetworkUtils.getItemStackHashCode(stack));
        buf.writeBoolean(NetworkUtils.hasPattern(network, stack));
    }

    public static void writeFluidStack(ByteBuf buf, FluidStack stack) {
        buf.writeInt(NetworkUtils.getFluidStackHashCode(stack));
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)FluidRegistry.getFluidName((Fluid)stack.getFluid()));
        buf.writeInt(stack.amount);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.tag);
    }
}

