/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.api.storage;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public final class CompareUtils {
    public static final int COMPARE_DAMAGE = 1;
    public static final int COMPARE_NBT = 2;
    public static final int COMPARE_QUANTITY = 4;

    public static boolean compareStack(ItemStack left, ItemStack right) {
        return CompareUtils.compareStack(left, right, 7);
    }

    public static boolean compareStackNoQuantity(ItemStack left, ItemStack right) {
        return CompareUtils.compareStack(left, right, 3);
    }

    public static boolean compareStack(ItemStack left, ItemStack right, int flags) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right != null || left != null && right == null) {
            return false;
        }
        if (left.func_77973_b() != right.func_77973_b()) {
            return false;
        }
        if ((flags & 1) == 1 && left.func_77952_i() != right.func_77952_i()) {
            return false;
        }
        if ((flags & 2) == 2 && !CompareUtils.compareNbt(left, right)) {
            return false;
        }
        return (flags & 4) != 4 || left.field_77994_a == right.field_77994_a;
    }

    public static boolean compareStack(FluidStack left, FluidStack right, int flags) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right != null || left != null && right == null) {
            return false;
        }
        if (left.getFluid() != right.getFluid()) {
            return false;
        }
        if ((flags & 4) == 4 && left.amount != right.amount) {
            return false;
        }
        return (flags & 2) != 2 || left.tag == null || left.tag.equals((Object)right.tag);
    }

    public static boolean compareNbt(ItemStack left, ItemStack right) {
        if (!ItemStack.func_77970_a((ItemStack)left, (ItemStack)right)) {
            if (left.func_77942_o() && !right.func_77942_o() && left.func_77978_p().func_82582_d()) {
                return true;
            }
            return !left.func_77942_o() && right.func_77942_o() && right.func_77978_p().func_82582_d();
        }
        return true;
    }

    public static boolean compareStackOreDict(ItemStack left, ItemStack right) {
        int[] rightIds;
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right != null || left != null && right == null) {
            return false;
        }
        int[] leftIds = OreDictionary.getOreIDs((ItemStack)left);
        for (int i : rightIds = OreDictionary.getOreIDs((ItemStack)right)) {
            if (!ArrayUtils.contains((int[])leftIds, (int)i)) continue;
            return true;
        }
        return false;
    }
}

