/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.autocrafting;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.autocrafting.ICraftingPatternContainer;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.item.ItemPattern;

public class CraftingPattern
implements ICraftingPattern {
    private World world;
    private ICraftingPatternContainer container;
    private ItemStack stack;
    private List<ItemStack> inputs = new ArrayList<ItemStack>();
    private List<ItemStack> outputs = new ArrayList<ItemStack>();
    private List<ItemStack> byproducts = new ArrayList<ItemStack>();

    public CraftingPattern(World world, ICraftingPatternContainer container, ItemStack stack) {
        this.world = world;
        this.container = container;
        this.stack = stack;
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            ItemStack slot = ItemPattern.getSlot(stack, i);
            if (slot == null) continue;
            for (int j = 0; j < slot.field_77994_a; ++j) {
                this.inputs.add(ItemHandlerHelper.copyStackWithSize((ItemStack)slot, (int)1));
            }
            inv.func_70299_a(i, slot);
        }
        if (!ItemPattern.isProcessing(stack)) {
            ItemStack output = CraftingManager.func_77594_a().func_82787_a(inv, world);
            if (output != null) {
                this.outputs.add(output.func_77946_l());
                for (ItemStack remaining : CraftingManager.func_77594_a().func_180303_b(inv, world)) {
                    if (remaining == null) continue;
                    this.byproducts.add(remaining.func_77946_l());
                }
            }
        } else {
            this.outputs = ItemPattern.getOutputs(stack);
        }
    }

    @Override
    public ICraftingPatternContainer getContainer() {
        return this.container;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isValid() {
        return !this.inputs.isEmpty() && !this.outputs.isEmpty();
    }

    @Override
    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public String getId() {
        return ItemPattern.isProcessing(this.stack) ? "processing" : "normal";
    }

    @Override
    public int getQuantityPerRequest(ItemStack requested) {
        int quantity = 0;
        for (ItemStack output : this.outputs) {
            if (!CompareUtils.compareStackNoQuantity(requested, output)) continue;
            quantity += output.field_77994_a;
            if (ItemPattern.isProcessing(this.stack)) continue;
            break;
        }
        return quantity;
    }

    public boolean equals(Object other) {
        int i;
        if (!(other instanceof CraftingPattern)) {
            return false;
        }
        CraftingPattern otherPattern = (CraftingPattern)other;
        if (this.inputs.size() != otherPattern.inputs.size() || this.outputs.size() != otherPattern.outputs.size()) {
            return false;
        }
        for (i = 0; i < this.inputs.size(); ++i) {
            if (CompareUtils.compareStack(this.inputs.get(i), otherPattern.inputs.get(i))) continue;
            return false;
        }
        for (i = 0; i < this.outputs.size(); ++i) {
            if (CompareUtils.compareStack(this.outputs.get(i), otherPattern.outputs.get(i))) continue;
            return false;
        }
        return true;
    }
}

