/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.autocrafting.task;

import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.autocrafting.task.CraftingTask;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.apiimpl.storage.fluid.FluidUtils;

public class CraftingTaskNormal
extends CraftingTask {
    public CraftingTaskNormal(ICraftingPattern pattern) {
        super(pattern);
    }

    @Override
    public boolean update(World world, INetworkMaster network) {
        for (int i = 0; i < this.pattern.getInputs().size(); ++i) {
            this.checked[i] = true;
            ItemStack input = this.pattern.getInputs().get(i);
            if (this.satisfied[i]) continue;
            ItemStack received = FluidUtils.extractItemOrIfBucketLookInFluids(network, input, input.field_77994_a);
            if (received != null) {
                this.satisfied[i] = true;
                this.took.add(received);
                break;
            }
            this.tryCreateChild(network, i);
            break;
        }
        for (boolean item : this.satisfied) {
            if (item) continue;
            return false;
        }
        Object object = this.pattern.getOutputs().iterator();
        while (object.hasNext()) {
            ItemStack output = (ItemStack)object.next();
            network.insertItem(output, output.field_77994_a, false);
        }
        return true;
    }

    @Override
    public String getStatus() {
        StringBuilder builder = new StringBuilder();
        boolean missingItems = false;
        for (int i = 0; i < this.pattern.getInputs().size(); ++i) {
            ItemStack input = this.pattern.getInputs().get(i);
            if (this.satisfied[i] || this.childrenCreated[i] || !this.checked[i]) continue;
            if (!missingItems) {
                builder.append("I=gui.refinedstorage:crafting_monitor.missing_items\n");
                missingItems = true;
            }
            builder.append("T=").append(input.func_77977_a()).append(".name\n");
        }
        boolean itemsCrafting = false;
        for (int i = 0; i < this.pattern.getInputs().size(); ++i) {
            ItemStack input = this.pattern.getInputs().get(i);
            if (this.satisfied[i] || !this.childrenCreated[i] || !this.checked[i]) continue;
            if (!itemsCrafting) {
                builder.append("I=gui.refinedstorage:crafting_monitor.items_crafting\n");
                itemsCrafting = true;
            }
            builder.append("T=").append(input.func_77977_a()).append(".name\n");
        }
        return builder.toString();
    }

    @Override
    public int getProgress() {
        int satisfiedAmount = 0;
        for (boolean item : this.satisfied) {
            if (!item) continue;
            ++satisfiedAmount;
        }
        return (int)((float)satisfiedAmount / (float)this.satisfied.length * 100.0f);
    }
}

