/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.autocrafting.task;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.autocrafting.ICraftingPatternContainer;
import refinedstorage.api.autocrafting.task.CraftingTask;
import refinedstorage.api.autocrafting.task.ICraftingTask;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.apiimpl.storage.fluid.FluidUtils;

public class CraftingTaskProcessing
extends CraftingTask {
    public static final String NBT_SATISFIED_INSERTION = "SatisfiedInsertion";
    public static final String NBT_TILE_IN_USE = "TileInUse";
    private boolean[] satisfiedInsertion;
    private BlockPos tileInUse;
    private boolean waitingOnTileInUse;

    public CraftingTaskProcessing(ICraftingPattern pattern) {
        super(pattern);
        this.satisfiedInsertion = new boolean[pattern.getOutputs().size()];
    }

    public void setSatisfiedInsertion(boolean[] satisfiedInsertion) {
        this.satisfiedInsertion = satisfiedInsertion;
    }

    public void setTileInUse(BlockPos tileInUse) {
        this.tileInUse = tileInUse;
    }

    @Override
    public boolean update(World world, INetworkMaster network) {
        for (int i = 0; i < this.pattern.getInputs().size(); ++i) {
            this.checked[i] = true;
            ItemStack input = this.pattern.getInputs().get(i);
            if (this.satisfied[i]) continue;
            ItemStack received = FluidUtils.extractItemOrIfBucketLookInFluids(network, input, input.field_77994_a);
            if (received != null) {
                this.satisfied[i] = true;
                this.took.add(received);
                break;
            }
            this.tryCreateChild(network, i);
            break;
        }
        if (!this.isReadyToInsert()) {
            return false;
        }
        ICraftingPatternContainer container = this.pattern.getContainer();
        if (container.getFacingTile() == null) {
            this.tileInUse = null;
            this.waitingOnTileInUse = false;
        }
        if (!this.took.isEmpty() && container.getFacingTile() != null) {
            this.waitingOnTileInUse = this.isTileInUse(network);
            if (!this.waitingOnTileInUse) {
                this.tileInUse = this.pattern.getContainer().getFacingTile().func_174877_v();
                ItemStack toInsert = (ItemStack)this.took.get(0);
                if (ItemHandlerHelper.insertItem((IItemHandler)container.getFacingInventory(), (ItemStack)toInsert, (boolean)true) == null) {
                    ItemHandlerHelper.insertItem((IItemHandler)container.getFacingInventory(), (ItemStack)toInsert, (boolean)false);
                    this.took.remove(0);
                }
            }
        }
        return this.isReady();
    }

    private boolean isReady() {
        for (boolean item : this.satisfiedInsertion) {
            if (item) continue;
            return false;
        }
        return true;
    }

    private boolean isReadyToInsert() {
        for (boolean item : this.satisfied) {
            if (item) continue;
            return false;
        }
        return true;
    }

    private boolean isTileInUse(INetworkMaster network) {
        for (ICraftingTask task : network.getCraftingTasks()) {
            if (!this.isTileInUse(task)) continue;
            return true;
        }
        return false;
    }

    private boolean isTileInUse(ICraftingTask task) {
        if (task != this) {
            if (task.getChild() != null) {
                return this.isTileInUse(task.getChild());
            }
            if (task instanceof CraftingTaskProcessing) {
                CraftingTaskProcessing other = (CraftingTaskProcessing)task;
                if (other.tileInUse != null && other.tileInUse.equals((Object)this.pattern.getContainer().getFacingTile().func_174877_v()) && !other.pattern.equals(this.pattern)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onInserted(ItemStack stack) {
        if (this.isReady()) {
            return false;
        }
        for (int i = 0; i < this.pattern.getOutputs().size(); ++i) {
            ItemStack output = this.pattern.getOutputs().get(i);
            if (this.satisfiedInsertion[i] || !CompareUtils.compareStackNoQuantity(output, stack)) continue;
            this.satisfiedInsertion[i] = true;
            if (this.isReady()) {
                this.tileInUse = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        if (this.tileInUse != null) {
            tag.func_74772_a(NBT_TILE_IN_USE, this.tileInUse.func_177986_g());
        }
        CraftingTaskProcessing.writeBooleanArray(tag, NBT_SATISFIED_INSERTION, this.satisfiedInsertion);
        return tag;
    }

    @Override
    public String getStatus() {
        int i;
        StringBuilder builder = new StringBuilder();
        boolean missingItems = false;
        for (int i2 = 0; i2 < this.pattern.getInputs().size(); ++i2) {
            ItemStack input = this.pattern.getInputs().get(i2);
            if (this.satisfied[i2] || this.childrenCreated[i2]) continue;
            if (!missingItems) {
                builder.append("I=gui.refinedstorage:crafting_monitor.missing_items\n");
                missingItems = true;
            }
            builder.append("T=").append(input.func_77977_a()).append(".name\n");
        }
        boolean itemsCrafting = false;
        for (i = 0; i < this.pattern.getInputs().size(); ++i) {
            ItemStack input = this.pattern.getInputs().get(i);
            if (this.satisfied[i] || !this.childrenCreated[i]) continue;
            if (!itemsCrafting) {
                builder.append("I=gui.refinedstorage:crafting_monitor.items_crafting\n");
                itemsCrafting = true;
            }
            builder.append("T=").append(input.func_77977_a()).append(".name\n");
        }
        if (this.isReadyToInsert()) {
            builder.append("I=gui.refinedstorage:crafting_monitor.items_processing\n");
            for (i = 0; i < this.pattern.getInputs().size(); ++i) {
                builder.append("T=").append(this.pattern.getInputs().get(i).func_77977_a()).append(".name\n");
            }
            if (this.pattern.getContainer().getFacingTile() == null) {
                builder.append("B=gui.refinedstorage:crafting_monitor.machine_none");
            } else if (this.waitingOnTileInUse) {
                builder.append("B=gui.refinedstorage:crafting_monitor.machine_in_use");
            }
        }
        return builder.toString();
    }

    @Override
    public int getProgress() {
        int satisfiedAmount = 0;
        for (boolean item : this.satisfied) {
            if (!item) continue;
            ++satisfiedAmount;
        }
        for (boolean item : this.satisfiedInsertion) {
            if (!item) continue;
            ++satisfiedAmount;
        }
        return (int)((float)satisfiedAmount / (float)(this.satisfied.length + this.satisfiedInsertion.length) * 100.0f);
    }
}

