/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import refinedstorage.RefinedStorage;
import refinedstorage.RefinedStorageItems;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.INetworkNode;
import refinedstorage.api.network.IWirelessGridConsumer;
import refinedstorage.api.network.IWirelessGridHandler;
import refinedstorage.api.network.IWirelessTransmitter;
import refinedstorage.apiimpl.network.WirelessGridConsumer;
import refinedstorage.item.ItemWirelessGrid;

public class WirelessGridHandler
implements IWirelessGridHandler {
    private INetworkMaster network;
    private List<IWirelessGridConsumer> consumers = new ArrayList<IWirelessGridConsumer>();
    private List<IWirelessGridConsumer> consumersToRemove = new ArrayList<IWirelessGridConsumer>();

    public WirelessGridHandler(INetworkMaster network) {
        this.network = network;
    }

    @Override
    public void update() {
        this.consumers.removeAll(this.consumersToRemove);
        this.consumersToRemove.clear();
    }

    @Override
    public boolean onOpen(EntityPlayer player, World controllerWorld, EnumHand hand) {
        boolean inRange = false;
        for (INetworkNode node : this.network.getNodeGraph().all()) {
            IWirelessTransmitter transmitter;
            double distance;
            if (!(node instanceof IWirelessTransmitter) || node.getNodeWorld().field_73011_w.getDimension() != player.field_71093_bK || !((distance = Math.sqrt(Math.pow((double)(transmitter = (IWirelessTransmitter)((Object)node)).getOrigin().func_177958_n() - player.field_70165_t, 2.0) + Math.pow((double)transmitter.getOrigin().func_177956_o() - player.field_70163_u, 2.0) + Math.pow((double)transmitter.getOrigin().func_177952_p() - player.field_70161_v, 2.0))) < (double)transmitter.getRange())) continue;
            inRange = true;
            break;
        }
        if (!inRange) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (RefinedStorage.INSTANCE.config.wirelessGridUsesEnergy && stack.func_77952_i() != 1 && RefinedStorageItems.WIRELESS_GRID.getEnergyStored(stack) <= RefinedStorage.INSTANCE.config.wirelessGridOpenUsage) {
            return true;
        }
        this.consumers.add(new WirelessGridConsumer(player, stack));
        player.openGui((Object)RefinedStorage.INSTANCE, 12, player.field_70170_p, hand.ordinal(), controllerWorld.field_73011_w.getDimension(), 0);
        this.network.sendItemStorageToClient((EntityPlayerMP)player);
        this.drainEnergy(player, RefinedStorage.INSTANCE.config.wirelessGridOpenUsage);
        return true;
    }

    @Override
    public void onClose(EntityPlayer player) {
        IWirelessGridConsumer consumer = this.getConsumer(player);
        if (consumer != null) {
            this.consumersToRemove.add(consumer);
        }
    }

    @Override
    public void drainEnergy(EntityPlayer player, int energy) {
        IWirelessGridConsumer consumer = this.getConsumer(player);
        if (consumer != null && RefinedStorage.INSTANCE.config.wirelessGridUsesEnergy) {
            ItemWirelessGrid item = RefinedStorageItems.WIRELESS_GRID;
            if (consumer.getStack().func_77952_i() != 1) {
                item.extractEnergy(consumer.getStack(), energy, false);
                if (item.getEnergyStored(consumer.getStack()) <= 0) {
                    this.onClose(player);
                    consumer.getPlayer().func_71053_j();
                }
            }
        }
    }

    @Override
    public IWirelessGridConsumer getConsumer(EntityPlayer player) {
        for (IWirelessGridConsumer consumer : this.consumers) {
            if (consumer.getPlayer() != player) continue;
            return consumer;
        }
        return null;
    }
}

