/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.network.grid;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.api.network.grid.IFluidGridHandler;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.apiimpl.storage.fluid.FluidUtils;

public class FluidGridHandler
implements IFluidGridHandler {
    private INetworkMaster network;

    public FluidGridHandler(INetworkMaster network) {
        this.network = network;
    }

    @Override
    public void onExtract(int hash, boolean shift, EntityPlayerMP player) {
        FluidStack stack = this.network.getFluidStorage().get(hash);
        if (stack != null && FluidUtils.hasFluidBucket(stack)) {
            ItemStack bucket = FluidUtils.extractBucket(this.network);
            if (bucket == null) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack slot = player.field_71071_by.func_70301_a(i);
                    if (!CompareUtils.compareStackNoQuantity(FluidUtils.EMPTY_BUCKET, slot)) continue;
                    bucket = FluidUtils.EMPTY_BUCKET.func_77946_l();
                    player.field_71071_by.func_70298_a(i, 1);
                    break;
                }
            }
            if (bucket != null) {
                ((IFluidHandler)bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(NetworkUtils.extractFluid(this.network, stack, 1000), true);
                if (shift) {
                    if (!player.field_71071_by.func_70441_a(bucket.func_77946_l())) {
                        InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)bucket);
                    }
                } else {
                    player.field_71071_by.func_70437_b(bucket);
                    player.func_71113_k();
                }
            }
        }
    }

    @Override
    @Nullable
    public ItemStack onInsert(ItemStack container) {
        FluidStack stack = FluidUtils.getFluidFromStack(container, true);
        if (stack != null && this.network.insertFluid(stack, stack.amount, true) == null) {
            FluidStack drained = FluidUtils.getFluidFromStack(container, false);
            this.network.insertFluid(drained, drained.amount, false);
        }
        return container;
    }

    @Override
    public void onInsertHeldContainer(EntityPlayerMP player) {
        this.onInsert(player.field_71071_by.func_70445_o());
        player.func_71113_k();
    }
}

