/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.network.grid;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.RefinedStorage;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.autocrafting.task.ICraftingTask;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.api.network.grid.IItemGridHandler;
import refinedstorage.api.storage.CompareUtils;

public class ItemGridHandler
implements IItemGridHandler {
    private INetworkMaster network;

    public ItemGridHandler(INetworkMaster network) {
        this.network = network;
    }

    @Override
    public void onExtract(int hash, int flags, EntityPlayerMP player) {
        ItemStack took;
        ItemStack item = this.network.getItemStorage().get(hash);
        if (item == null) {
            return;
        }
        int itemSize = item.field_77994_a;
        boolean single = (flags & 2) == 2;
        ItemStack held = player.field_71071_by.func_70445_o();
        if (single ? held != null && (!CompareUtils.compareStackNoQuantity(item, held) || held.field_77994_a + 1 > held.func_77976_d()) : player.field_71071_by.func_70445_o() != null) {
            return;
        }
        int size = 64;
        if ((flags & 1) == 1 && itemSize > 1) {
            size = itemSize / 2;
            if (size > 32) {
                size = 32;
            }
        } else if (single) {
            size = 1;
        } else if ((flags & 4) == 4) {
            // empty if block
        }
        if ((took = NetworkUtils.extractItem(this.network, item, size = Math.min(size, item.func_77973_b().getItemStackLimit(item)))) != null) {
            if ((flags & 4) == 4) {
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)), (ItemStack)took, (boolean)false);
                if (remainder != null) {
                    this.network.insertItem(remainder, remainder.field_77994_a, false);
                }
            } else {
                if (single && held != null) {
                    ++held.field_77994_a;
                } else {
                    player.field_71071_by.func_70437_b(took);
                }
                player.func_71113_k();
            }
            this.network.getWirelessGridHandler().drainEnergy((EntityPlayer)player, RefinedStorage.INSTANCE.config.wirelessGridExtractUsage);
        }
    }

    @Override
    public ItemStack onInsert(EntityPlayerMP player, ItemStack stack) {
        ItemStack remainder = this.network.insertItem(stack, stack.field_77994_a, false);
        this.network.getWirelessGridHandler().drainEnergy((EntityPlayer)player, RefinedStorage.INSTANCE.config.wirelessGridInsertUsage);
        return remainder;
    }

    @Override
    public void onInsertHeldItem(EntityPlayerMP player, boolean single) {
        int size;
        if (player.field_71071_by.func_70445_o() == null) {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70445_o();
        int n = size = single ? 1 : stack.field_77994_a;
        if (single) {
            if (this.network.insertItem(stack, size, true) == null) {
                this.network.insertItem(stack, size, false);
                stack.field_77994_a -= size;
                if (stack.field_77994_a == 0) {
                    player.field_71071_by.func_70437_b(null);
                }
            }
        } else {
            player.field_71071_by.func_70437_b(this.network.insertItem(stack, size, false));
        }
        player.func_71113_k();
        this.network.getWirelessGridHandler().drainEnergy((EntityPlayer)player, RefinedStorage.INSTANCE.config.wirelessGridInsertUsage);
    }

    @Override
    public void onCraftingRequested(int hash, int quantity) {
        if (quantity <= 0) {
            return;
        }
        ItemStack stack = this.network.getItemStorage().get(hash);
        if (stack == null) {
            return;
        }
        ICraftingPattern pattern = NetworkUtils.getPattern(this.network, stack);
        if (pattern != null) {
            int quantityPerRequest = pattern.getQuantityPerRequest(stack);
            while (quantity > 0) {
                this.network.addCraftingTask(NetworkUtils.createCraftingTask(this.network, pattern));
                quantity -= quantityPerRequest;
            }
        }
    }

    @Override
    public void onCraftingCancelRequested(int id, int depth) {
        block5: {
            block3: {
                ICraftingTask task;
                block4: {
                    if (id < 0 || id >= this.network.getCraftingTasks().size()) break block3;
                    task = this.network.getCraftingTasks().get(id);
                    if (depth != 0) break block4;
                    this.network.cancelCraftingTask(task);
                    break block5;
                }
                for (int i = 0; i < depth - 1 && task != null; task = task.getChild(), ++i) {
                }
                if (task == null) break block5;
                task.getChild().onCancelled(this.network);
                task.setChild(null);
                break block5;
            }
            if (id == -1) {
                for (ICraftingTask task : this.network.getCraftingTasks()) {
                    this.network.cancelCraftingTask(task);
                }
            }
        }
    }
}

