/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.storage.fluid;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.api.storage.fluid.IFluidStorage;
import refinedstorage.apiimpl.storage.fluid.FluidUtils;

public abstract class FluidStorageNBT
implements IFluidStorage {
    private static final int PROTOCOL = 1;
    private static final String NBT_PROTOCOL = "Protocol";
    private static final String NBT_FLUIDS = "Fluids";
    private static final String NBT_STORED = "Stored";
    private NBTTagCompound tag;
    private int capacity;
    private TileEntity tile;
    private List<FluidStack> stacks = new ArrayList<FluidStack>();

    public FluidStorageNBT(NBTTagCompound tag, int capacity, @Nullable TileEntity tile) {
        this.tag = tag;
        this.capacity = capacity;
        this.tile = tile;
        this.readFromNBT();
    }

    public void readFromNBT() {
        NBTTagList list = (NBTTagList)this.tag.func_74781_a(NBT_FLUIDS);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)list.func_150305_b(i));
            if (stack == null) continue;
            this.stacks.add(stack);
        }
    }

    public void writeToNBT() {
        NBTTagList list = new NBTTagList();
        for (FluidStack stack : this.stacks) {
            list.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        this.tag.func_74782_a(NBT_FLUIDS, (NBTBase)list);
        this.tag.func_74768_a(NBT_PROTOCOL, 1);
    }

    @Override
    public List<FluidStack> getStacks() {
        return this.stacks;
    }

    @Override
    public synchronized FluidStack insertFluid(FluidStack stack, int size, boolean simulate) {
        for (FluidStack otherStack : this.stacks) {
            if (!otherStack.isFluidEqual(stack)) continue;
            if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
                int remainingSpace = this.getCapacity() - this.getStored();
                if (remainingSpace <= 0) {
                    return FluidUtils.copyStackWithSize(stack, size);
                }
                if (!simulate) {
                    this.tag.func_74768_a(NBT_STORED, this.getStored() + remainingSpace);
                    otherStack.amount += remainingSpace;
                    this.onStorageChanged();
                }
                return FluidUtils.copyStackWithSize(otherStack, size - remainingSpace);
            }
            if (!simulate) {
                this.tag.func_74768_a(NBT_STORED, this.getStored() + size);
                otherStack.amount += size;
                this.onStorageChanged();
            }
            return null;
        }
        if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
            int remainingSpace = this.getCapacity() - this.getStored();
            if (remainingSpace <= 0) {
                return FluidUtils.copyStackWithSize(stack, size);
            }
            if (!simulate) {
                this.tag.func_74768_a(NBT_STORED, this.getStored() + remainingSpace);
                this.stacks.add(FluidUtils.copyStackWithSize(stack, remainingSpace));
                this.onStorageChanged();
            }
            return FluidUtils.copyStackWithSize(stack, size - remainingSpace);
        }
        if (!simulate) {
            this.tag.func_74768_a(NBT_STORED, this.getStored() + size);
            this.stacks.add(FluidUtils.copyStackWithSize(stack, size));
            this.onStorageChanged();
        }
        return null;
    }

    @Override
    public synchronized FluidStack extractFluid(FluidStack stack, int size, int flags) {
        for (FluidStack otherStack : this.stacks) {
            if (!CompareUtils.compareStack(otherStack, stack, flags)) continue;
            if (size > otherStack.amount) {
                size = otherStack.amount;
            }
            if (otherStack.amount - size == 0) {
                this.stacks.remove(otherStack);
            } else {
                otherStack.amount -= size;
            }
            this.tag.func_74768_a(NBT_STORED, this.getStored() - size);
            this.onStorageChanged();
            return FluidUtils.copyStackWithSize(otherStack, size);
        }
        return null;
    }

    public void onStorageChanged() {
        if (this.tile != null) {
            this.tile.func_70296_d();
        }
    }

    @Override
    public int getStored() {
        return FluidStorageNBT.getStoredFromNBT(this.tag);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public NBTTagCompound getTag() {
        return this.tag;
    }

    public static int getStoredFromNBT(NBTTagCompound tag) {
        return tag.func_74762_e(NBT_STORED);
    }

    public static NBTTagCompound createNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(NBT_FLUIDS, (NBTBase)new NBTTagList());
        tag.func_74768_a(NBT_STORED, 0);
        tag.func_74768_a(NBT_PROTOCOL, 1);
        return tag;
    }

    public static boolean isValid(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_FLUIDS) && stack.func_77978_p().func_74764_b(NBT_STORED);
    }

    public static ItemStack createStackWithNBT(ItemStack stack) {
        stack.func_77982_d(FluidStorageNBT.createNBT());
        return stack;
    }
}

