/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.storage.fluid;

import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.NetworkUtils;

public final class FluidUtils {
    public static final ItemStack EMPTY_BUCKET = new ItemStack(Items.field_151133_ar);

    public static FluidStack copyStackWithSize(FluidStack stack, int size) {
        FluidStack copy = stack.copy();
        copy.amount = size;
        return copy;
    }

    public static FluidStack copy(FluidStack stack) {
        return stack == null ? null : stack.copy();
    }

    public static FluidStack getFluidFromStack(ItemStack stack, boolean simulate) {
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return ((IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).drain(1000, !simulate);
        }
        if (stack.func_77973_b() instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)stack.func_77973_b()).drain(stack, 1000, !simulate);
        }
        return null;
    }

    public static boolean hasFluidBucket(FluidStack stack) {
        return stack.getFluid() == FluidRegistry.WATER || stack.getFluid() == FluidRegistry.LAVA || FluidRegistry.getBucketFluids().contains(stack.getFluid());
    }

    public static ItemStack extractItemOrIfBucketLookInFluids(INetworkMaster network, ItemStack stack, int size) {
        FluidStack fluidStack;
        ItemStack result = NetworkUtils.extractItem(network, stack, size);
        if (result == null && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (fluidStack = FluidUtils.getFluidFromStack(stack, true)) != null && FluidUtils.hasFluidBucket(fluidStack)) {
            result = FluidUtils.extractBucket(network);
            if (result != null) {
                ((IFluidHandler)result.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(NetworkUtils.extractFluid(network, fluidStack, 1000), true);
            } else {
                NetworkUtils.scheduleCraftingTaskIfUnscheduled(network, EMPTY_BUCKET, 1, 3);
            }
        }
        return result;
    }

    public static ItemStack extractBucket(INetworkMaster network) {
        return NetworkUtils.extractItem(network, EMPTY_BUCKET, 1);
    }
}

