/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.storage.fluid;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.api.storage.fluid.IFluidStorage;
import refinedstorage.api.storage.fluid.IFluidStorageProvider;
import refinedstorage.api.storage.fluid.IGroupedFluidStorage;

public class GroupedFluidStorage
implements IGroupedFluidStorage {
    private INetworkMaster network;
    private List<IFluidStorage> storages = new ArrayList<IFluidStorage>();
    private Multimap<Fluid, FluidStack> stacks = ArrayListMultimap.create();

    public GroupedFluidStorage(INetworkMaster network) {
        this.network = network;
    }

    @Override
    public void rebuild() {
        this.storages.clear();
        this.network.getNodeGraph().all().stream().filter(node -> node.canUpdate() && node instanceof IFluidStorageProvider).forEach(node -> ((IFluidStorageProvider)((Object)node)).addFluidStorages(this.storages));
        this.stacks.clear();
        for (IFluidStorage storage : this.storages) {
            for (FluidStack stack : storage.getStacks()) {
                this.add(stack, true);
            }
        }
        this.network.sendFluidStorageToClient();
    }

    @Override
    public void add(@Nonnull FluidStack stack, boolean rebuilding) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!otherStack.isFluidEqual(stack)) continue;
            otherStack.amount += stack.amount;
            if (!rebuilding) {
                this.network.sendFluidStorageDeltaToClient(stack, stack.amount);
            }
            return;
        }
        this.stacks.put((Object)stack.getFluid(), (Object)stack.copy());
        if (!rebuilding) {
            this.network.sendFluidStorageDeltaToClient(stack, stack.amount);
        }
    }

    @Override
    public void remove(@Nonnull FluidStack stack) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!otherStack.isFluidEqual(stack)) continue;
            otherStack.amount -= stack.amount;
            if (otherStack.amount == 0) {
                this.stacks.remove((Object)otherStack.getFluid(), (Object)otherStack);
            }
            this.network.sendFluidStorageDeltaToClient(stack, -stack.amount);
            return;
        }
    }

    @Override
    @Nullable
    public FluidStack get(@Nonnull FluidStack stack, int flags) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!CompareUtils.compareStack(otherStack, stack, flags)) continue;
            return otherStack;
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack get(int hash) {
        for (FluidStack stack : this.stacks.values()) {
            if (NetworkUtils.getFluidStackHashCode(stack) != hash) continue;
            return stack;
        }
        return null;
    }

    @Override
    public Collection<FluidStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    public List<IFluidStorage> getStorages() {
        return this.storages;
    }
}

