/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.storage.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.api.storage.item.IGroupedItemStorage;
import refinedstorage.api.storage.item.IItemStorage;
import refinedstorage.api.storage.item.IItemStorageProvider;

public class GroupedItemStorage
implements IGroupedItemStorage {
    private INetworkMaster network;
    private List<IItemStorage> storages = new ArrayList<IItemStorage>();
    private Multimap<Item, ItemStack> stacks = ArrayListMultimap.create();

    public GroupedItemStorage(INetworkMaster network) {
        this.network = network;
    }

    @Override
    public void rebuild() {
        this.storages.clear();
        this.network.getNodeGraph().all().stream().filter(node -> node.canUpdate() && node instanceof IItemStorageProvider).forEach(node -> ((IItemStorageProvider)((Object)node)).addItemStorages(this.storages));
        this.stacks.clear();
        for (IItemStorage storage : this.storages) {
            for (ItemStack stack : storage.getItems()) {
                this.add(stack, true);
            }
        }
        for (ICraftingPattern pattern : this.network.getPatterns()) {
            for (ItemStack output : pattern.getOutputs()) {
                ItemStack patternStack = output.func_77946_l();
                patternStack.field_77994_a = 0;
                this.add(patternStack, true);
            }
        }
        this.network.sendItemStorageToClient();
    }

    @Override
    public void add(@Nonnull ItemStack stack, boolean rebuilding) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!CompareUtils.compareStackNoQuantity(otherStack, stack)) continue;
            otherStack.field_77994_a += stack.field_77994_a;
            if (!rebuilding) {
                this.network.sendItemStorageDeltaToClient(stack, stack.field_77994_a);
            }
            return;
        }
        this.stacks.put((Object)stack.func_77973_b(), (Object)stack.func_77946_l());
        if (!rebuilding) {
            this.network.sendItemStorageDeltaToClient(stack, stack.field_77994_a);
        }
    }

    @Override
    public void remove(@Nonnull ItemStack stack) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!CompareUtils.compareStackNoQuantity(otherStack, stack)) continue;
            otherStack.field_77994_a -= stack.field_77994_a;
            if (otherStack.field_77994_a == 0 && !NetworkUtils.hasPattern(this.network, stack)) {
                this.stacks.remove((Object)otherStack.func_77973_b(), (Object)otherStack);
            }
            this.network.sendItemStorageDeltaToClient(stack, -stack.field_77994_a);
            return;
        }
    }

    @Override
    @Nullable
    public ItemStack get(@Nonnull ItemStack stack, int flags) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!CompareUtils.compareStack(otherStack, stack, flags)) continue;
            return otherStack;
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack get(int hash) {
        for (ItemStack stack : this.stacks.values()) {
            if (NetworkUtils.getItemStackHashCode(stack) != hash) continue;
            return stack;
        }
        return null;
    }

    @Override
    public Collection<ItemStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    public List<IItemStorage> getStorages() {
        return this.storages;
    }
}

