/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import refinedstorage.RefinedStorage;
import refinedstorage.RefinedStorageBlocks;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.block.BlockBase;
import refinedstorage.block.EnumControllerType;
import refinedstorage.item.ItemBlockController;
import refinedstorage.tile.TileController;

public class BlockController
extends BlockBase {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", EnumControllerType.class);
    private static final PropertyInteger ENERGY = PropertyInteger.func_177719_a((String)"energy", (int)0, (int)7);

    public BlockController() {
        super("controller");
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> subItems) {
        for (int i = 0; i <= 1; ++i) {
            subItems.add(ItemBlockController.createStackWithNBT(new ItemStack(item, 1, i)));
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return this.createBlockStateBuilder().add(new IProperty[]{TYPE}).add(new IProperty[]{ENERGY}).build();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)(meta == 0 ? EnumControllerType.NORMAL : EnumControllerType.CREATIVE)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b((IProperty)TYPE) == EnumControllerType.NORMAL ? 0 : 1;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileController controller = (TileController)world.func_175625_s(pos);
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)ENERGY, (Comparable)Integer.valueOf(controller.getEnergyScaledForDisplay()));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileController();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)RefinedStorage.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        if (!world.field_72995_K) {
            TileController controller = (TileController)world.func_175625_s(pos);
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null && tag.func_74764_b("Energy")) {
                controller.getEnergy().receiveEnergy(tag.func_74762_e("Energy"), false);
            }
        }
        super.func_180633_a(world, pos, state, player, stack);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            ((TileController)world.func_175625_s(pos)).onDestroyed();
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        super.func_189540_a(state, world, pos, block);
        if (!world.field_72995_K) {
            NetworkUtils.rebuildGraph((TileController)world.func_175625_s(pos));
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack stack = new ItemStack((Block)RefinedStorageBlocks.CONTROLLER, 1, RefinedStorageBlocks.CONTROLLER.func_176201_c(state));
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("Energy", ((TileController)world.func_175625_s(pos)).getEnergy().getEnergyStored());
        stack.func_77978_p().func_74768_a("EnergyCapacity", ((TileController)world.func_175625_s(pos)).getEnergy().getMaxEnergyStored());
        drops.add(stack);
        return drops;
    }

    @Override
    public Item createItem() {
        return new ItemBlockController();
    }
}

