/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import refinedstorage.RefinedStorage;
import refinedstorage.block.BlockCable;
import refinedstorage.block.EnumPlacementType;
import refinedstorage.tile.TileImporter;

public class BlockImporter
extends BlockCable {
    public static final AxisAlignedBB LINE_NORTH_1_AABB = BlockImporter.createAABB(6, 6, 4, 10, 10, 6);
    public static final AxisAlignedBB LINE_NORTH_2_AABB = BlockImporter.createAABB(5, 5, 2, 11, 11, 4);
    public static final AxisAlignedBB LINE_NORTH_3_AABB = BlockImporter.createAABB(3, 3, 0, 13, 13, 2);
    public static final AxisAlignedBB LINE_EAST_1_AABB = BlockImporter.createAABB(10, 6, 6, 12, 10, 10);
    public static final AxisAlignedBB LINE_EAST_2_AABB = BlockImporter.createAABB(12, 5, 5, 14, 11, 11);
    public static final AxisAlignedBB LINE_EAST_3_AABB = BlockImporter.createAABB(14, 3, 3, 16, 13, 13);
    public static final AxisAlignedBB LINE_SOUTH_1_AABB = BlockImporter.createAABB(6, 6, 10, 10, 10, 12);
    public static final AxisAlignedBB LINE_SOUTH_2_AABB = BlockImporter.createAABB(5, 5, 12, 11, 11, 14);
    public static final AxisAlignedBB LINE_SOUTH_3_AABB = BlockImporter.createAABB(3, 3, 14, 13, 13, 16);
    public static final AxisAlignedBB LINE_WEST_1_AABB = BlockImporter.createAABB(4, 6, 6, 6, 10, 10);
    public static final AxisAlignedBB LINE_WEST_2_AABB = BlockImporter.createAABB(2, 5, 5, 4, 11, 11);
    public static final AxisAlignedBB LINE_WEST_3_AABB = BlockImporter.createAABB(0, 3, 3, 2, 13, 13);
    public static final AxisAlignedBB LINE_UP_1_AABB = BlockImporter.createAABB(6, 10, 6, 10, 12, 10);
    public static final AxisAlignedBB LINE_UP_2_AABB = BlockImporter.createAABB(5, 12, 5, 11, 14, 11);
    public static final AxisAlignedBB LINE_UP_3_AABB = BlockImporter.createAABB(3, 14, 3, 13, 16, 13);
    public static final AxisAlignedBB LINE_DOWN_1_AABB = BlockImporter.createAABB(6, 4, 6, 10, 6, 10);
    public static final AxisAlignedBB LINE_DOWN_2_AABB = BlockImporter.createAABB(5, 2, 5, 11, 4, 11);
    public static final AxisAlignedBB LINE_DOWN_3_AABB = BlockImporter.createAABB(3, 0, 3, 13, 2, 13);

    public BlockImporter(String name) {
        super(name);
    }

    public BlockImporter() {
        this("importer");
    }

    @Override
    public List<AxisAlignedBB> getNonUnionizedCollisionBoxes(IBlockState state) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
            case NORTH: {
                boxes.add(LINE_NORTH_1_AABB);
                boxes.add(LINE_NORTH_2_AABB);
                boxes.add(LINE_NORTH_3_AABB);
                break;
            }
            case EAST: {
                boxes.add(LINE_EAST_1_AABB);
                boxes.add(LINE_EAST_2_AABB);
                boxes.add(LINE_EAST_3_AABB);
                break;
            }
            case SOUTH: {
                boxes.add(LINE_SOUTH_1_AABB);
                boxes.add(LINE_SOUTH_2_AABB);
                boxes.add(LINE_SOUTH_3_AABB);
                break;
            }
            case WEST: {
                boxes.add(LINE_WEST_1_AABB);
                boxes.add(LINE_WEST_2_AABB);
                boxes.add(LINE_WEST_3_AABB);
                break;
            }
            case UP: {
                boxes.add(LINE_UP_1_AABB);
                boxes.add(LINE_UP_2_AABB);
                boxes.add(LINE_UP_3_AABB);
                break;
            }
            case DOWN: {
                boxes.add(LINE_DOWN_1_AABB);
                boxes.add(LINE_DOWN_2_AABB);
                boxes.add(LINE_DOWN_3_AABB);
            }
        }
        return boxes;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileImporter();
    }

    public boolean onBlockActivatedDefault(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.hitCablePart(state, world, pos, hitX, hitY, hitZ)) {
            return false;
        }
        if (!world.field_72995_K) {
            player.openGui((Object)RefinedStorage.INSTANCE, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public EnumPlacementType getPlacementType() {
        return EnumPlacementType.ANY;
    }
}

