/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.block;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.block.BlockBase;
import refinedstorage.tile.TileNode;

public abstract class BlockNode
extends BlockBase {
    private static final PropertyBool CONNECTED = PropertyBool.func_177716_a((String)"connected");

    public BlockNode(String name) {
        super(name);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    protected BlockStateContainer.Builder createBlockStateBuilder() {
        BlockStateContainer.Builder builder = super.createBlockStateBuilder();
        if (this.hasConnectivityState()) {
            builder.add(new IProperty[]{CONNECTED});
        }
        return builder;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return this.createBlockStateBuilder().build();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.hasConnectivityState()) {
            return super.func_176221_a(state, world, pos).func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(((TileNode)world.func_175625_s(pos)).isConnected()));
        }
        return super.func_176221_a(state, world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.func_180633_a(world, pos, state, player, stack);
        if (!world.field_72995_K) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity tile = world.func_175625_s(pos.func_177972_a(facing));
                if (!(tile instanceof TileNode) || !((TileNode)tile).isConnected()) continue;
                NetworkUtils.rebuildGraph(((TileNode)tile).getNetwork());
                break;
            }
        }
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        INetworkMaster network = null;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileNode) {
            network = ((TileNode)tile).getNetwork();
        }
        super.func_180663_b(world, pos, state);
        if (network != null) {
            NetworkUtils.rebuildGraph(network);
        }
    }

    public boolean hasConnectivityState() {
        return false;
    }
}

