/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import refinedstorage.block.EnumGridType;
import refinedstorage.container.ContainerBase;
import refinedstorage.container.slot.SlotDisabled;
import refinedstorage.container.slot.SlotGridCrafting;
import refinedstorage.container.slot.SlotGridCraftingResult;
import refinedstorage.container.slot.SlotOutput;
import refinedstorage.container.slot.SlotSpecimenLegacy;
import refinedstorage.tile.TileBase;
import refinedstorage.tile.grid.IGrid;
import refinedstorage.tile.grid.TileGrid;
import refinedstorage.tile.grid.WirelessGrid;

public class ContainerGrid
extends ContainerBase {
    private IGrid grid;
    private SlotGridCraftingResult craftingResultSlot;
    private SlotDisabled patternResultSlot;

    public ContainerGrid(IGrid grid, EntityPlayer player) {
        super(grid instanceof TileBase ? (TileBase)((Object)grid) : null, player);
        int i;
        int y;
        int x;
        this.grid = grid;
        this.addPlayerInventory(8, grid.getType() == EnumGridType.CRAFTING || grid.getType() == EnumGridType.PATTERN ? 165 : 126);
        if (grid.getType() == EnumGridType.CRAFTING) {
            x = 26;
            y = 96;
            for (i = 0; i < 9; ++i) {
                this.func_75146_a(new SlotGridCrafting((IInventory)((TileGrid)grid).getMatrix(), i, x, y));
                x += 18;
                if ((i + 1) % 3 != 0) continue;
                y += 18;
                x = 26;
            }
            this.craftingResultSlot = new SlotGridCraftingResult(this, player, (TileGrid)grid, 0, 134, 114);
            this.func_75146_a((Slot)this.craftingResultSlot);
        } else if (grid.getType() == EnumGridType.PATTERN) {
            x = 8;
            y = 96;
            for (i = 0; i < 9; ++i) {
                this.func_75146_a(new SlotSpecimenLegacy((IInventory)((TileGrid)grid).getMatrix(), i, x, y, false));
                x += 18;
                if ((i + 1) % 3 != 0) continue;
                y += 18;
                x = 8;
            }
            this.patternResultSlot = new SlotDisabled((IInventory)((TileGrid)grid).getResult(), 0, 116, 114);
            this.func_75146_a(this.patternResultSlot);
            this.func_75146_a((Slot)new SlotItemHandler(((TileGrid)grid).getPatterns(), 0, 152, 96));
            this.func_75146_a((Slot)new SlotOutput(((TileGrid)grid).getPatterns(), 1, 152, 132));
        }
        if (grid.getType() != EnumGridType.FLUID) {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)grid.getFilter(), i2, 204, 6 + 18 * i2));
            }
        }
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public void sendCraftingSlots() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof SlotGridCrafting) && slot != this.craftingResultSlot) continue;
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                ((IContainerListener)this.field_75149_d.get(j)).func_71111_a((Container)this, i, slot.func_75211_c());
            }
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K && this.grid instanceof WirelessGrid) {
            ((WirelessGrid)this.grid).onClose(player);
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot == this.craftingResultSlot || slot == this.patternResultSlot ? false : super.func_94530_a(stack, slot);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        Slot slot;
        if (!player.field_70170_p.field_72995_K && (slot = (Slot)this.field_75151_b.get(slotIndex)).func_75216_d()) {
            if (slot == this.craftingResultSlot) {
                ((TileGrid)this.grid).onCraftedShift(this, player);
            } else if (slot != this.patternResultSlot && !(slot instanceof SlotSpecimenLegacy)) {
                if (this.grid.getType() != EnumGridType.FLUID && this.grid.getItemHandler() != null) {
                    slot.func_75215_d(this.grid.getItemHandler().onInsert((EntityPlayerMP)player, slot.func_75211_c()));
                } else if (this.grid.getType() == EnumGridType.FLUID && this.grid.getFluidHandler() != null) {
                    slot.func_75215_d(this.grid.getFluidHandler().onInsert(slot.func_75211_c()));
                }
                this.func_75142_b();
            }
        }
        return null;
    }
}

