/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.items.SlotItemHandler;
import org.lwjgl.input.Mouse;
import refinedstorage.apiimpl.storage.fluid.FluidRenderer;
import refinedstorage.gui.Scrollbar;
import refinedstorage.gui.sidebutton.SideButton;
import refinedstorage.inventory.ItemHandlerFluid;

public abstract class GuiBase
extends GuiContainer {
    private static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();
    public static final FluidRenderer FLUID_RENDERER = new FluidRenderer(-1, 16, 16);
    protected static final int SIDE_BUTTON_WIDTH = 20;
    protected static final int SIDE_BUTTON_HEIGHT = 20;
    private List<SideButton> sideButtons = new ArrayList<SideButton>();
    private int lastButtonId = 0;
    private int lastSideButtonY = 6;
    protected int field_146294_l;
    protected int field_146295_m;
    protected Scrollbar scrollbar;

    public GuiBase(Container container, int width, int height) {
        super(container);
        this.field_146294_l = width;
        this.field_146295_m = height;
        this.field_146999_f = width;
        this.field_147000_g = height;
    }

    public void func_73866_w_() {
        if (this.sideButtons.size() > 0) {
            this.field_146999_f -= 20;
        }
        super.func_73866_w_();
        this.sideButtons.clear();
        this.lastButtonId = 0;
        this.lastSideButtonY = 6;
        this.init(this.field_147003_i, this.field_147009_r);
        if (this.sideButtons.size() > 0) {
            this.field_146999_f += 20;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.update(this.field_147003_i, this.field_147009_r);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.scrollbar != null) {
            this.scrollbar.update(this, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_146976_a(float renderPartialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackground(this.field_147003_i, this.field_147009_r, mouseX, mouseY);
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            FluidStack stack;
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (!(slot instanceof SlotItemHandler) || !(((SlotItemHandler)slot).getItemHandler() instanceof ItemHandlerFluid) || (stack = ((ItemHandlerFluid)((SlotItemHandler)slot).getItemHandler()).getFluidStackInSlot(slot.getSlotIndex())) == null) continue;
            FLUID_RENDERER.draw(this.field_146297_k, this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, stack);
        }
        if (this.scrollbar != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.scrollbar.draw(this);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mouseX -= this.field_147003_i;
        mouseY -= this.field_147009_r;
        String sideButtonTooltip = null;
        for (SideButton sideButton : this.sideButtons) {
            sideButton.draw(this, sideButton.getX() + 2, sideButton.getY() + 1);
            if (!this.inBounds(sideButton.getX(), sideButton.getY(), 20, 20, mouseX, mouseY)) continue;
            sideButtonTooltip = sideButton.getTooltip(this);
        }
        this.drawForeground(mouseX, mouseY);
        if (sideButtonTooltip != null) {
            this.drawTooltip(mouseX, mouseY, sideButtonTooltip);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int d = Mouse.getEventDWheel();
        if (this.scrollbar != null && d != 0) {
            this.scrollbar.wheel(d);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        this.sideButtons.stream().filter(b -> b.getId() == button.field_146127_k).findFirst().ifPresent(SideButton::actionPerformed);
    }

    public GuiButton addButton(int x, int y, int w, int h) {
        return this.addButton(x, y, w, h, "");
    }

    public GuiButton addButton(int x, int y, int w, int h, String text) {
        return this.addButton(x, y, w, h, text, true);
    }

    public GuiCheckBox addCheckBox(int x, int y, String text, boolean checked) {
        GuiCheckBox checkBox = new GuiCheckBox(this.lastButtonId++, x, y, text, checked);
        this.field_146292_n.add(checkBox);
        return checkBox;
    }

    public GuiButton addButton(int x, int y, int w, int h, String text, boolean enabled) {
        GuiButton button = new GuiButton(this.lastButtonId++, x, y, w, h, text);
        button.field_146124_l = enabled;
        this.field_146292_n.add(button);
        return button;
    }

    public void addSideButton(SideButton button) {
        button.setX(-19);
        button.setY(this.lastSideButtonY);
        button.setId(this.addButton((int)(this.field_147003_i + button.getX()), (int)(this.field_147009_r + button.getY()), (int)20, (int)20).field_146127_k);
        this.lastSideButtonY += 24;
        this.sideButtons.add(button);
    }

    public boolean inBounds(int x, int y, int w, int h, int ox, int oy) {
        return ox >= x && ox <= x + w && oy >= y && oy <= y + h;
    }

    public void bindTexture(String file) {
        this.bindTexture("refinedstorage", file);
    }

    public void bindTexture(String base, String file) {
        String id = base + ":" + file;
        if (!TEXTURE_CACHE.containsKey(id)) {
            TEXTURE_CACHE.put(id, new ResourceLocation(base, "textures/" + file));
        }
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE_CACHE.get(id));
    }

    public void drawItem(int x, int y, ItemStack stack) {
        this.drawItem(x, y, stack, false);
    }

    public void drawItem(int x, int y, ItemStack stack, boolean withOverlay) {
        this.drawItem(x, y, stack, withOverlay, null);
    }

    public void drawItem(int x, int y, ItemStack stack, boolean withOverlay, String message) {
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        this.field_146296_j.func_175042_a(stack, x, y);
        if (withOverlay) {
            this.drawItemOverlay(stack, message, x, y);
        }
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    public void drawItemOverlay(ItemStack stack, String text, int x, int y) {
        this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, "");
        if (text != null) {
            this.drawQuantity(x, y, text);
        }
    }

    public void drawQuantity(int x, int y, String qty) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)1.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179101_C();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179097_i();
        this.field_146289_q.func_175063_a(qty, (float)(30 - this.field_146289_q.func_78256_a(qty)), 22.0f, 0xFFFFFF);
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public void drawString(int x, int y, String message) {
        this.drawString(x, y, message, 0x404040);
    }

    public void drawString(int x, int y, String message, int color) {
        GlStateManager.func_179140_f();
        this.field_146289_q.func_78276_b(message, x, y, color);
        GlStateManager.func_179145_e();
    }

    public void drawTooltip(int x, int y, String message) {
        this.drawTooltip(x, y, Arrays.asList(message.split("\n")));
    }

    public void drawTooltip(int x, int y, List<String> lines) {
        GlStateManager.func_179140_f();
        this.func_146283_a(lines, x, y);
        GlStateManager.func_179145_e();
    }

    public void drawTooltip(int x, int y, ItemStack stack) {
        GlStateManager.func_179140_f();
        this.func_146285_a(stack, x, y);
        GlStateManager.func_179145_e();
    }

    public void drawTexture(int x, int y, int textureX, int textureY, int width, int height) {
        this.func_73729_b(x, y, textureX, textureY, width, height);
    }

    public String t(String name, Object ... format) {
        return I18n.func_135052_a((String)name, (Object[])format);
    }

    public abstract void init(int var1, int var2);

    public abstract void update(int var1, int var2);

    public abstract void drawBackground(int var1, int var2, int var3, int var4);

    public abstract void drawForeground(int var1, int var2);

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    protected int calculateOffsetOnScale(int pos, float scale) {
        float multiplier = (float)pos / scale;
        return (int)multiplier;
    }
}

