/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.gui;

import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import refinedstorage.container.ContainerController;
import refinedstorage.gui.GuiBase;
import refinedstorage.gui.Scrollbar;
import refinedstorage.gui.sidebutton.SideButtonRedstoneMode;
import refinedstorage.tile.ClientNode;
import refinedstorage.tile.TileController;

public class GuiController
extends GuiBase {
    private static final int VISIBLE_ROWS = 2;
    private TileController controller;
    private int barX = 8;
    private int barY = 20;
    private int barWidth = 16;
    private int barHeight = 59;

    public GuiController(ContainerController container, TileController controller) {
        super(container, 176, 181);
        this.controller = controller;
        this.scrollbar = new Scrollbar(157, 20, 12, 59);
    }

    @Override
    public void init(int x, int y) {
        this.addSideButton(new SideButtonRedstoneMode(TileController.REDSTONE_MODE));
    }

    @Override
    public void update(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() > 2);
        this.scrollbar.setMaxOffset(this.getRows() - 2);
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/controller.png");
        this.drawTexture(x, y, 0, 0, this.field_146294_l, this.field_146295_m);
        int barHeightNew = TileController.getEnergyScaled(TileController.ENERGY_STORED.getValue(), TileController.ENERGY_CAPACITY.getValue(), this.barHeight);
        this.drawTexture(x + this.barX, y + this.barY + this.barHeight - barHeightNew, 178, this.barHeight - barHeightNew, this.barWidth, barHeightNew);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, this.t("gui.refinedstorage:controller." + this.controller.getType().getId(), new Object[0]));
        this.drawString(7, 87, this.t("container.inventory", new Object[0]));
        int x = 33;
        int y = 26;
        int slot = this.scrollbar.getOffset() * 2;
        RenderHelper.func_74520_c();
        List<ClientNode> nodes = TileController.NODES.getValue();
        ClientNode nodeHovering = null;
        for (int i = 0; i < 4; ++i) {
            if (slot < nodes.size()) {
                ClientNode node = nodes.get(slot);
                this.drawItem(x, y + 5, node.getStack());
                float scale = 0.5f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                this.drawString(this.calculateOffsetOnScale(x + 1, scale), this.calculateOffsetOnScale(y - 2, scale), node.getStack().func_82833_r());
                this.drawString(this.calculateOffsetOnScale(x + 21, scale), this.calculateOffsetOnScale(y + 10, scale), node.getAmount() + "x");
                GlStateManager.func_179121_F();
                if (this.inBounds(x, y, 16, 16, mouseX, mouseY)) {
                    nodeHovering = node;
                }
            }
            if (i == 1) {
                x = 33;
                y += 30;
            } else {
                x += 60;
            }
            ++slot;
        }
        if (nodeHovering != null) {
            this.drawTooltip(mouseX, mouseY, this.t("misc.refinedstorage:energy_usage_minimal", nodeHovering.getEnergyUsage()));
        }
        if (this.inBounds(this.barX, this.barY, this.barWidth, this.barHeight, mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, this.t("misc.refinedstorage:energy_usage", TileController.ENERGY_USAGE.getValue()) + "\n" + this.t("misc.refinedstorage:energy_stored", TileController.ENERGY_STORED.getValue(), TileController.ENERGY_CAPACITY.getValue()));
        }
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)TileController.NODES.getValue().size() / 2.0f));
    }
}

