/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.gui;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import refinedstorage.RefinedStorage;
import refinedstorage.container.ContainerCraftingMonitor;
import refinedstorage.gui.GuiBase;
import refinedstorage.gui.Scrollbar;
import refinedstorage.gui.sidebutton.SideButtonRedstoneMode;
import refinedstorage.network.MessageCraftingMonitorCancel;
import refinedstorage.tile.ClientCraftingTask;
import refinedstorage.tile.TileCraftingMonitor;

public class GuiCraftingMonitor
extends GuiBase {
    private static final int VISIBLE_ROWS = 5;
    private static final int ITEM_WIDTH = 143;
    private static final int ITEM_HEIGHT = 18;
    private TileCraftingMonitor craftingMonitor;
    private GuiButton cancelButton;
    private GuiButton cancelAllButton;
    private int itemSelected = -1;
    private int itemSelectedX = -1;
    private int itemSelectedY = -1;

    public GuiCraftingMonitor(ContainerCraftingMonitor container, TileCraftingMonitor craftingMonitor) {
        super(container, 176, 230);
        this.craftingMonitor = craftingMonitor;
        this.scrollbar = new Scrollbar(157, 20, 12, 89);
    }

    @Override
    public void init(int x, int y) {
        this.addSideButton(new SideButtonRedstoneMode(TileCraftingMonitor.REDSTONE_MODE));
        String cancel = this.t("gui.cancel", new Object[0]);
        String cancelAll = this.t("misc.refinedstorage:cancel_all", new Object[0]);
        int cancelButtonWidth = 14 + this.field_146289_q.func_78256_a(cancel);
        int cancelAllButtonWidth = 14 + this.field_146289_q.func_78256_a(cancelAll);
        this.cancelButton = this.addButton(x + 7, y + 114, cancelButtonWidth, 20, cancel, false);
        this.cancelAllButton = this.addButton(x + 7 + cancelButtonWidth + 4, y + 114, cancelAllButtonWidth, 20, cancelAll, false);
    }

    @Override
    public void update(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() > 5);
        this.scrollbar.setMaxOffset(this.getRows() - 5);
        if (this.itemSelected >= this.getTasks().size()) {
            this.itemSelected = -1;
        }
        this.cancelButton.field_146124_l = this.itemSelected != -1;
        this.cancelAllButton.field_146124_l = this.getTasks().size() > 0;
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/crafting_monitor.png");
        this.drawTexture(x, y, 0, 0, this.field_146294_l, this.field_146295_m);
        if (this.itemSelectedX != -1 && this.itemSelectedY != -1) {
            this.drawTexture(x + this.itemSelectedX, y + this.itemSelectedY, 0, 232, 143, 18);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        int ox;
        this.drawString(7, 7, this.t("gui.refinedstorage:crafting_monitor", new Object[0]));
        this.drawString(7, 137, this.t("container.inventory", new Object[0]));
        int item = this.scrollbar.getOffset();
        RenderHelper.func_74520_c();
        String[] lines = null;
        int x = ox = 8;
        int y = 20;
        this.itemSelectedX = -1;
        this.itemSelectedY = -1;
        for (int i = 0; i < 5; ++i) {
            if (item < this.getTasks().size()) {
                ClientCraftingTask task = this.getTasks().get(item);
                if (item == this.itemSelected) {
                    this.itemSelectedX = x;
                    this.itemSelectedY = y;
                }
                if (task.getDepth() > 0) {
                    x = (int)((float)x + (16.0f - (float)(task.getChildren() - task.getDepth()) / (float)task.getChildren() * 16.0f));
                }
                this.drawItem(x + 2, y + 1, task.getOutput());
                float scale = 0.5f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                this.drawString(this.calculateOffsetOnScale(x + 21, scale), this.calculateOffsetOnScale(y + 7, scale), task.getOutput().func_82833_r());
                if (task.getProgress() != -1) {
                    this.drawString(this.calculateOffsetOnScale(ox + 143 - 15, scale), this.calculateOffsetOnScale(y + 7, scale), task.getProgress() + "%");
                }
                GlStateManager.func_179121_F();
                if (this.inBounds(x + 2, y + 1, 16, 16, mouseX, mouseY) && !task.getStatus().trim().equals("")) {
                    lines = task.getStatus().split("\n");
                    for (int j = 0; j < lines.length; ++j) {
                        String line = lines[j];
                        if (line.startsWith("T=")) {
                            line = this.t(line.substring(2), new Object[0]);
                        } else if (line.startsWith("I=")) {
                            line = TextFormatting.YELLOW + this.t(line.substring(2), new Object[0]);
                        } else if (line.startsWith("B=")) {
                            line = TextFormatting.BLUE + this.t(line.substring(2), new Object[0]);
                        }
                        lines[j] = line;
                    }
                }
                x = ox;
                y += 18;
            }
            ++item;
        }
        if (lines != null) {
            this.drawTooltip(mouseX, mouseY, Arrays.asList(lines));
        }
    }

    private int getRows() {
        return this.getTasks().size();
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.cancelButton && this.itemSelected != -1) {
            ClientCraftingTask task = this.getTasks().get(this.itemSelected);
            RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageCraftingMonitorCancel(this.craftingMonitor, task.getId(), task.getDepth()));
        } else if (button == this.cancelAllButton && this.getTasks().size() > 0) {
            RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageCraftingMonitorCancel(this.craftingMonitor, -1, 0));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.itemSelected = -1;
        if (mouseButton == 0 && this.inBounds(8, 20, 144, 90, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            int item = this.scrollbar.getOffset();
            for (int i = 0; i < 5; ++i) {
                int ix = 8;
                int iy = 20 + i * 18;
                if (!this.inBounds(ix, iy, 143, 18, mouseX - this.field_147003_i, mouseY - this.field_147009_r) || item + i >= this.getTasks().size()) continue;
                this.itemSelected = item + i;
            }
        }
    }

    private List<ClientCraftingTask> getTasks() {
        return TileCraftingMonitor.TASKS.getValue();
    }
}

