/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import refinedstorage.container.ContainerConstructor;
import refinedstorage.container.ContainerController;
import refinedstorage.container.ContainerCrafter;
import refinedstorage.container.ContainerCraftingMonitor;
import refinedstorage.container.ContainerDestructor;
import refinedstorage.container.ContainerDetector;
import refinedstorage.container.ContainerDiskDrive;
import refinedstorage.container.ContainerDiskManipulator;
import refinedstorage.container.ContainerExporter;
import refinedstorage.container.ContainerExternalStorage;
import refinedstorage.container.ContainerFluidInterface;
import refinedstorage.container.ContainerFluidStorage;
import refinedstorage.container.ContainerGrid;
import refinedstorage.container.ContainerGridFilter;
import refinedstorage.container.ContainerImporter;
import refinedstorage.container.ContainerInterface;
import refinedstorage.container.ContainerNetworkTransmitter;
import refinedstorage.container.ContainerProcessingPatternEncoder;
import refinedstorage.container.ContainerRelay;
import refinedstorage.container.ContainerSolderer;
import refinedstorage.container.ContainerStorage;
import refinedstorage.container.ContainerWirelessTransmitter;
import refinedstorage.gui.GuiConstructor;
import refinedstorage.gui.GuiController;
import refinedstorage.gui.GuiCrafter;
import refinedstorage.gui.GuiCraftingMonitor;
import refinedstorage.gui.GuiDestructor;
import refinedstorage.gui.GuiDetector;
import refinedstorage.gui.GuiDiskManipulator;
import refinedstorage.gui.GuiExporter;
import refinedstorage.gui.GuiFluidInterface;
import refinedstorage.gui.GuiGridFilter;
import refinedstorage.gui.GuiImporter;
import refinedstorage.gui.GuiInterface;
import refinedstorage.gui.GuiNetworkTransmitter;
import refinedstorage.gui.GuiProcessingPatternEncoder;
import refinedstorage.gui.GuiRelay;
import refinedstorage.gui.GuiSolderer;
import refinedstorage.gui.GuiStorage;
import refinedstorage.gui.GuiWirelessTransmitter;
import refinedstorage.gui.grid.GuiGrid;
import refinedstorage.tile.IStorageGui;
import refinedstorage.tile.TileConstructor;
import refinedstorage.tile.TileController;
import refinedstorage.tile.TileCrafter;
import refinedstorage.tile.TileCraftingMonitor;
import refinedstorage.tile.TileDestructor;
import refinedstorage.tile.TileDetector;
import refinedstorage.tile.TileDiskDrive;
import refinedstorage.tile.TileDiskManipulator;
import refinedstorage.tile.TileExporter;
import refinedstorage.tile.TileFluidInterface;
import refinedstorage.tile.TileFluidStorage;
import refinedstorage.tile.TileImporter;
import refinedstorage.tile.TileInterface;
import refinedstorage.tile.TileNetworkTransmitter;
import refinedstorage.tile.TileProcessingPatternEncoder;
import refinedstorage.tile.TileRelay;
import refinedstorage.tile.TileSolderer;
import refinedstorage.tile.TileStorage;
import refinedstorage.tile.TileWirelessTransmitter;
import refinedstorage.tile.externalstorage.TileExternalStorage;
import refinedstorage.tile.grid.TileGrid;
import refinedstorage.tile.grid.WirelessGrid;

public class GuiHandler
implements IGuiHandler {
    private Container getContainer(int ID, EntityPlayer player, TileEntity tile) {
        switch (ID) {
            case 0: {
                return new ContainerController((TileController)tile, player);
            }
            case 1: {
                return new ContainerGrid((TileGrid)tile, player);
            }
            case 2: {
                return new ContainerDiskDrive((TileDiskDrive)tile, player);
            }
            case 3: {
                return new ContainerImporter((TileImporter)tile, player);
            }
            case 4: {
                return new ContainerExporter((TileExporter)tile, player);
            }
            case 5: {
                return new ContainerDetector((TileDetector)tile, player);
            }
            case 6: {
                return new ContainerSolderer((TileSolderer)tile, player);
            }
            case 7: {
                return new ContainerDestructor((TileDestructor)tile, player);
            }
            case 8: {
                return new ContainerConstructor((TileConstructor)tile, player);
            }
            case 9: {
                return new ContainerStorage((TileStorage)tile, player);
            }
            case 20: {
                return new ContainerExternalStorage((TileExternalStorage)tile, player);
            }
            case 10: {
                return new ContainerRelay((TileRelay)tile, player);
            }
            case 11: {
                return new ContainerInterface((TileInterface)tile, player);
            }
            case 13: {
                return new ContainerCraftingMonitor((TileCraftingMonitor)tile, player);
            }
            case 14: {
                return new ContainerWirelessTransmitter((TileWirelessTransmitter)tile, player);
            }
            case 15: {
                return new ContainerCrafter((TileCrafter)tile, player);
            }
            case 16: {
                return new ContainerProcessingPatternEncoder((TileProcessingPatternEncoder)tile, player);
            }
            case 18: {
                return new ContainerNetworkTransmitter((TileNetworkTransmitter)tile, player);
            }
            case 19: {
                return new ContainerFluidInterface((TileFluidInterface)tile, player);
            }
            case 21: {
                return new ContainerFluidStorage((TileFluidStorage)tile, player);
            }
            case 22: {
                return new ContainerDiskManipulator((TileDiskManipulator)tile, player);
            }
        }
        return null;
    }

    private WirelessGrid getWirelessGrid(EntityPlayer player, int hand, int controllerDimension) {
        return new WirelessGrid(controllerDimension, player.func_184586_b(EnumHand.values()[hand]));
    }

    private ContainerGrid getWirelessGridContainer(EntityPlayer player, int hand, int controllerDimension) {
        return new ContainerGrid(this.getWirelessGrid(player, hand, controllerDimension), player);
    }

    private ContainerGridFilter getGridFilterContainer(EntityPlayer player, int hand) {
        return new ContainerGridFilter(player, player.func_184586_b(EnumHand.values()[hand]));
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 12) {
            return this.getWirelessGridContainer(player, x, y);
        }
        if (ID == 17) {
            return this.getGridFilterContainer(player, x);
        }
        return this.getContainer(ID, player, world.func_175625_s(new BlockPos(x, y, z)));
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        switch (ID) {
            case 0: {
                return new GuiController((ContainerController)this.getContainer(ID, player, tile), (TileController)tile);
            }
            case 1: {
                return new GuiGrid((ContainerGrid)this.getContainer(ID, player, tile), (TileGrid)tile);
            }
            case 12: {
                return this.getWirelessGridGui(player, x, y);
            }
            case 2: {
                return new GuiStorage((ContainerDiskDrive)this.getContainer(ID, player, tile), (IStorageGui)tile, "gui/disk_drive.png");
            }
            case 3: {
                return new GuiImporter((ContainerImporter)this.getContainer(ID, player, tile));
            }
            case 4: {
                return new GuiExporter((ContainerExporter)this.getContainer(ID, player, tile));
            }
            case 5: {
                return new GuiDetector((ContainerDetector)this.getContainer(ID, player, tile));
            }
            case 6: {
                return new GuiSolderer((ContainerSolderer)this.getContainer(ID, player, tile), (TileSolderer)tile);
            }
            case 7: {
                return new GuiDestructor((ContainerDestructor)this.getContainer(ID, player, tile));
            }
            case 8: {
                return new GuiConstructor((ContainerConstructor)this.getContainer(ID, player, tile));
            }
            case 9: {
                return new GuiStorage((ContainerStorage)this.getContainer(ID, player, tile), (TileStorage)tile);
            }
            case 20: {
                return new GuiStorage((ContainerExternalStorage)this.getContainer(ID, player, tile), (TileExternalStorage)tile);
            }
            case 10: {
                return new GuiRelay((ContainerRelay)this.getContainer(ID, player, tile));
            }
            case 11: {
                return new GuiInterface((ContainerInterface)this.getContainer(ID, player, tile));
            }
            case 13: {
                return new GuiCraftingMonitor((ContainerCraftingMonitor)this.getContainer(ID, player, tile), (TileCraftingMonitor)tile);
            }
            case 14: {
                return new GuiWirelessTransmitter((ContainerWirelessTransmitter)this.getContainer(ID, player, tile));
            }
            case 15: {
                return new GuiCrafter((ContainerCrafter)this.getContainer(ID, player, tile));
            }
            case 16: {
                return new GuiProcessingPatternEncoder((ContainerProcessingPatternEncoder)this.getContainer(ID, player, tile), (TileProcessingPatternEncoder)tile);
            }
            case 17: {
                return new GuiGridFilter(this.getGridFilterContainer(player, x));
            }
            case 18: {
                return new GuiNetworkTransmitter((ContainerNetworkTransmitter)this.getContainer(ID, player, tile), (TileNetworkTransmitter)tile);
            }
            case 19: {
                return new GuiFluidInterface((ContainerFluidInterface)this.getContainer(ID, player, tile));
            }
            case 21: {
                return new GuiStorage((ContainerFluidStorage)this.getContainer(ID, player, tile), (TileFluidStorage)tile);
            }
            case 22: {
                return new GuiDiskManipulator((ContainerDiskManipulator)this.getContainer(ID, player, tile));
            }
        }
        return null;
    }

    private GuiGrid getWirelessGridGui(EntityPlayer player, int hand, int controllerDimension) {
        WirelessGrid grid = this.getWirelessGrid(player, hand, controllerDimension);
        return new GuiGrid(new ContainerGrid(grid, player), grid);
    }
}

