/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.gui;

import com.google.common.primitives.Ints;
import java.io.IOException;
import net.minecraft.client.gui.GuiTextField;
import refinedstorage.container.ContainerBase;
import refinedstorage.gui.GuiBase;
import refinedstorage.gui.sidebutton.SideButtonCompare;
import refinedstorage.gui.sidebutton.SideButtonMode;
import refinedstorage.gui.sidebutton.SideButtonRedstoneMode;
import refinedstorage.gui.sidebutton.SideButtonType;
import refinedstorage.tile.IStorageGui;
import refinedstorage.tile.data.TileDataManager;

public class GuiStorage
extends GuiBase {
    private IStorageGui gui;
    private String texture;
    private GuiTextField priorityField;
    private int barX = 8;
    private int barY = 54;
    private int barWidth = 16;
    private int barHeight = 58;

    public GuiStorage(ContainerBase container, IStorageGui gui, String texture) {
        super(container, 176, 211);
        this.gui = gui;
        this.texture = texture;
    }

    public GuiStorage(ContainerBase container, IStorageGui gui) {
        this(container, gui, "gui/storage.png");
    }

    @Override
    public void init(int x, int y) {
        if (this.gui.getRedstoneModeParameter() != null) {
            this.addSideButton(new SideButtonRedstoneMode(this.gui.getRedstoneModeParameter()));
        }
        if (this.gui.getTypeParameter() != null) {
            this.addSideButton(new SideButtonType(this.gui.getTypeParameter()));
        }
        if (this.gui.getFilterParameter() != null) {
            this.addSideButton(new SideButtonMode(this.gui.getFilterParameter()));
        }
        if (this.gui.getCompareParameter() != null) {
            this.addSideButton(new SideButtonCompare(this.gui.getCompareParameter(), 1));
            this.addSideButton(new SideButtonCompare(this.gui.getCompareParameter(), 2));
        }
        this.priorityField = new GuiTextField(0, this.field_146289_q, x + 98 + 1, y + 54 + 1, 29, this.field_146289_q.field_78288_b);
        this.priorityField.func_146185_a(false);
        this.priorityField.func_146189_e(true);
        this.priorityField.func_146193_g(0xFFFFFF);
        this.priorityField.func_146205_d(true);
        this.priorityField.func_146195_b(false);
        this.updatePriority(this.gui.getPriorityParameter().getValue());
    }

    @Override
    public void update(int x, int y) {
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture(this.texture);
        this.drawTexture(x, y, 0, 0, this.field_146294_l, this.field_146295_m);
        int barHeightNew = (int)((float)this.gui.getStored() / (float)this.gui.getCapacity() * (float)this.barHeight);
        this.drawTexture(x + this.barX, y + this.barY + this.barHeight - barHeightNew, 179, this.barHeight - barHeightNew, this.barWidth, barHeightNew);
        this.priorityField.func_146194_f();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, this.t(this.gui.getGuiTitle(), new Object[0]));
        this.drawString(7, 42, this.gui.getCapacity() == -1 ? this.t("misc.refinedstorage:storage.stored_minimal", this.gui.getStored()) : this.t("misc.refinedstorage:storage.stored_capacity_minimal", this.gui.getStored(), this.gui.getCapacity()));
        this.drawString(97, 42, this.t("misc.refinedstorage:priority", new Object[0]));
        this.drawString(7, 117, this.t("container.inventory", new Object[0]));
        if (this.inBounds(this.barX, this.barY, this.barWidth, this.barHeight, mouseX, mouseY)) {
            int full = 0;
            if (this.gui.getCapacity() >= 0) {
                full = (int)((float)this.gui.getStored() / (float)this.gui.getCapacity() * 100.0f);
            }
            this.drawTooltip(mouseX, mouseY, this.t("misc.refinedstorage:storage.full", full));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.priorityField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (!this.func_146983_a(keyCode)) {
            if (this.priorityField.func_146201_a(character, keyCode)) {
                Integer result = Ints.tryParse((String)this.priorityField.func_146179_b());
                if (result != null) {
                    TileDataManager.setParameter(this.gui.getPriorityParameter(), result);
                }
            } else {
                super.func_73869_a(character, keyCode);
            }
        }
    }

    public void updatePriority(int priority) {
        if (this.priorityField != null) {
            this.priorityField.func_146180_a(String.valueOf(priority));
        }
    }
}

