/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.gui.grid;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import refinedstorage.RefinedStorage;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.block.EnumGridType;
import refinedstorage.container.ContainerGrid;
import refinedstorage.gui.GuiBase;
import refinedstorage.gui.Scrollbar;
import refinedstorage.gui.grid.GridFilteredItem;
import refinedstorage.gui.grid.GuiCraftingStart;
import refinedstorage.gui.grid.sorting.GridSortingName;
import refinedstorage.gui.grid.sorting.GridSortingQuantity;
import refinedstorage.gui.grid.stack.ClientStackFluid;
import refinedstorage.gui.grid.stack.ClientStackItem;
import refinedstorage.gui.grid.stack.IClientStack;
import refinedstorage.gui.sidebutton.SideButtonGridSearchBoxMode;
import refinedstorage.gui.sidebutton.SideButtonGridSortingDirection;
import refinedstorage.gui.sidebutton.SideButtonGridSortingType;
import refinedstorage.gui.sidebutton.SideButtonGridViewType;
import refinedstorage.gui.sidebutton.SideButtonRedstoneMode;
import refinedstorage.integration.jei.IntegrationJEI;
import refinedstorage.integration.jei.RefinedStorageJEIPlugin;
import refinedstorage.network.MessageGridCraftingClear;
import refinedstorage.network.MessageGridFluidInsertHeld;
import refinedstorage.network.MessageGridFluidPull;
import refinedstorage.network.MessageGridItemInsertHeld;
import refinedstorage.network.MessageGridItemPull;
import refinedstorage.network.MessageGridPatternCreate;
import refinedstorage.tile.grid.IGrid;
import refinedstorage.tile.grid.TileGrid;

public class GuiGrid
extends GuiBase {
    public static final GridSortingQuantity SORTING_QUANTITY = new GridSortingQuantity();
    public static final GridSortingName SORTING_NAME = new GridSortingName();
    public static final ListMultimap<Item, ClientStackItem> ITEMS = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    public static final ListMultimap<Fluid, ClientStackFluid> FLUIDS = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    public static List<IClientStack> STACKS = new ArrayList<IClientStack>();
    private static boolean markedForSorting;
    private boolean wasConnected;
    private GuiTextField searchField;
    private ContainerGrid container;
    private IGrid grid;
    private int slotNumber;

    public static void markForSorting() {
        markedForSorting = true;
    }

    public GuiGrid(ContainerGrid container, IGrid grid) {
        super(container, grid.getType() == EnumGridType.FLUID ? 193 : 227, grid.getType() == EnumGridType.CRAFTING || grid.getType() == EnumGridType.PATTERN ? 247 : 208);
        this.container = container;
        this.grid = grid;
        this.wasConnected = grid.isConnected();
        this.scrollbar = new Scrollbar(174, 20, 12, grid.getType() == EnumGridType.CRAFTING || grid.getType() == EnumGridType.PATTERN || grid.getType() == EnumGridType.FLUID ? 70 : 88);
    }

    @Override
    public void init(int x, int y) {
        if (this.grid.getRedstoneModeConfig() != null) {
            this.addSideButton(new SideButtonRedstoneMode(this.grid.getRedstoneModeConfig()));
        }
        int sx = x + 80 + 1;
        int sy = y + 6 + 1;
        if (this.searchField == null) {
            this.searchField = new GuiTextField(0, this.field_146289_q, sx, sy, 82, this.field_146289_q.field_78288_b);
            this.searchField.func_146185_a(false);
            this.searchField.func_146189_e(true);
            this.searchField.func_146193_g(0xFFFFFF);
            this.updateSearchFieldFocus(this.grid.getSearchBoxMode());
        } else {
            this.searchField.field_146209_f = sx;
            this.searchField.field_146210_g = sy;
        }
        if (this.grid.getType() != EnumGridType.FLUID) {
            this.addSideButton(new SideButtonGridViewType(this.grid));
        }
        this.addSideButton(new SideButtonGridSortingDirection(this.grid));
        this.addSideButton(new SideButtonGridSortingType(this.grid));
        this.addSideButton(new SideButtonGridSearchBoxMode(this));
        this.sortItems();
    }

    public IGrid getGrid() {
        return this.grid;
    }

    private void sortItems() {
        ArrayList<IClientStack> stacks = new ArrayList<IClientStack>();
        if (this.grid.isConnected()) {
            stacks.addAll(this.grid.getType() == EnumGridType.FLUID ? FLUIDS.values() : ITEMS.values());
            String query = this.searchField.func_146179_b().trim().toLowerCase();
            Iterator t = stacks.iterator();
            while (t.hasNext()) {
                IClientStack stack = (IClientStack)t.next();
                if (this.grid.getType() != EnumGridType.FLUID) {
                    List<GridFilteredItem> filteredItems = this.grid.getFilteredItems();
                    boolean found = filteredItems.isEmpty();
                    for (GridFilteredItem filteredItem : filteredItems) {
                        if (!CompareUtils.compareStack(((ClientStackItem)stack).getStack(), filteredItem.getStack(), filteredItem.getCompare())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        t.remove();
                        continue;
                    }
                    if (this.grid.getViewType() == 1 && ((ClientStackItem)stack).isCraftable()) {
                        t.remove();
                        continue;
                    }
                    if (this.grid.getViewType() == 2 && !((ClientStackItem)stack).isCraftable()) {
                        t.remove();
                        continue;
                    }
                }
                if (query.startsWith("@")) {
                    String[] parts = query.split(" ");
                    String modId = parts[0].substring(1);
                    String modIdFromItem = stack.getModId();
                    if (!modIdFromItem.contains(modId)) {
                        t.remove();
                        continue;
                    }
                    if (parts.length < 2) continue;
                    StringBuilder itemFromMod = new StringBuilder();
                    for (int i = 1; i < parts.length; ++i) {
                        itemFromMod.append(parts[i]);
                        if (i == parts.length - 1) continue;
                        itemFromMod.append(" ");
                    }
                    if (stack.getName().toLowerCase().contains(itemFromMod.toString())) continue;
                    t.remove();
                    continue;
                }
                if (stack.getName().toLowerCase().contains(query)) continue;
                t.remove();
            }
            SORTING_NAME.setSortingDirection(this.grid.getSortingDirection());
            SORTING_QUANTITY.setSortingDirection(this.grid.getSortingDirection());
            Collections.sort(stacks, SORTING_NAME);
            if (this.grid.getSortingType() == 0) {
                Collections.sort(stacks, SORTING_QUANTITY);
            }
        }
        STACKS = stacks;
        this.scrollbar.setEnabled(this.getRows() > this.getVisibleRows());
        this.scrollbar.setMaxOffset(this.getRows() - this.getVisibleRows());
    }

    @Override
    public void update(int x, int y) {
        if (this.wasConnected != this.grid.isConnected()) {
            this.wasConnected = this.grid.isConnected();
            GuiGrid.markForSorting();
        }
        if (markedForSorting) {
            markedForSorting = false;
            this.sortItems();
        }
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)STACKS.size() / 9.0f));
    }

    private boolean isOverSlotWithItem() {
        return this.grid.isConnected() && this.isOverSlot() && this.slotNumber < STACKS.size();
    }

    private boolean isOverSlot() {
        return this.slotNumber >= 0;
    }

    private boolean isOverSlotArea(int mouseX, int mouseY) {
        return this.inBounds(7, 19, 162, 18 * this.getVisibleRows(), mouseX, mouseY);
    }

    private int getVisibleRows() {
        return this.grid.getType() == EnumGridType.CRAFTING || this.grid.getType() == EnumGridType.PATTERN ? 4 : 5;
    }

    private boolean isOverClear(int mouseX, int mouseY) {
        switch (this.grid.getType()) {
            case CRAFTING: {
                return this.inBounds(82, 95, 7, 7, mouseX, mouseY);
            }
            case PATTERN: {
                return this.inBounds(64, 95, 7, 7, mouseX, mouseY);
            }
        }
        return false;
    }

    private boolean isOverCreatePattern(int mouseX, int mouseY) {
        return this.grid.getType() == EnumGridType.PATTERN && this.inBounds(152, 114, 16, 16, mouseX, mouseY) && ((TileGrid)this.grid).canCreatePattern();
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        if (this.grid.getType() == EnumGridType.CRAFTING) {
            this.bindTexture("gui/crafting_grid.png");
        } else if (this.grid.getType() == EnumGridType.PATTERN) {
            this.bindTexture("gui/pattern_grid.png");
        } else {
            this.bindTexture("gui/grid.png");
        }
        this.drawTexture(x, y, 0, 0, this.field_146294_l, this.field_146295_m);
        if (this.grid.getType() == EnumGridType.PATTERN) {
            int ty = 0;
            if (this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
                ty = 1;
            }
            if (!((TileGrid)this.grid).canCreatePattern()) {
                ty = 2;
            }
            this.drawTexture(x + 152, y + 114, 240, ty * 16, 16, 16);
        }
        this.searchField.func_146194_f();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, this.t(this.grid.getGuiTitle(), new Object[0]));
        this.drawString(7, this.grid.getType() == EnumGridType.CRAFTING || this.grid.getType() == EnumGridType.PATTERN ? 153 : 114, this.t("container.inventory", new Object[0]));
        int x = 8;
        int y = 20;
        this.slotNumber = -1;
        int slot = this.scrollbar.getOffset() * 9;
        RenderHelper.func_74520_c();
        for (int i = 0; i < 9 * this.getVisibleRows(); ++i) {
            if (this.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isConnected()) {
                this.slotNumber = slot;
            }
            if (slot < STACKS.size()) {
                STACKS.get(slot).draw(this, x, y, GuiScreen.func_146272_n() && this.slotNumber == slot);
            }
            if (this.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isConnected()) {
                int color = this.grid.isConnected() ? -2130706433 : -10790053;
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                this.field_73735_i = 190.0f;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.func_73733_a(x, y, x + 16, y + 16, color, color);
                this.field_73735_i = 0.0f;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
            ++slot;
            x += 18;
            if ((i + 1) % 9 != 0) continue;
            x = 8;
            y += 18;
        }
        if (this.isOverSlotWithItem()) {
            this.drawTooltip(mouseX, mouseY, STACKS.get(this.slotNumber).getTooltip());
        }
        if (this.isOverClear(mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, this.t("misc.refinedstorage:clear", new Object[0]));
        }
        if (this.isOverCreatePattern(mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, this.t("gui.refinedstorage:grid.pattern_create", new Object[0]));
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int clickedButton) throws IOException {
        boolean clickedCreatePattern;
        super.func_73864_a(mouseX, mouseY, clickedButton);
        this.searchField.func_146192_a(mouseX, mouseY, clickedButton);
        if (clickedButton == 1 && this.inBounds(79, 5, 90, 12, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            this.searchField.func_146180_a("");
            this.searchField.func_146195_b(true);
            this.sortItems();
            this.updateJEI();
        }
        boolean clickedClear = clickedButton == 0 && this.isOverClear(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        boolean bl = clickedCreatePattern = clickedButton == 0 && this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        if (clickedCreatePattern) {
            BlockPos gridPos = ((TileGrid)this.grid).func_174877_v();
            RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageGridPatternCreate(gridPos.func_177958_n(), gridPos.func_177956_o(), gridPos.func_177952_p()));
        } else if (this.grid.isConnected()) {
            if (clickedClear) {
                RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageGridCraftingClear((TileGrid)this.grid));
            }
            ItemStack held = this.container.getPlayer().field_71071_by.func_70445_o();
            if (this.isOverSlotArea(mouseX - this.field_147003_i, mouseY - this.field_147009_r) && held != null && (clickedButton == 0 || clickedButton == 1)) {
                RefinedStorage.INSTANCE.network.sendToServer((IMessage)(this.grid.getType() == EnumGridType.FLUID ? new MessageGridFluidInsertHeld() : new MessageGridItemInsertHeld(clickedButton == 1)));
            }
            if (this.isOverSlotWithItem()) {
                if (this.grid.getType() != EnumGridType.FLUID && (held == null || held != null && clickedButton == 2)) {
                    ClientStackItem stack = (ClientStackItem)STACKS.get(this.slotNumber);
                    if (stack.isCraftable() && (stack.getQuantity() == 0 || GuiScreen.func_146272_n() && GuiScreen.func_146271_m())) {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiCraftingStart(this, this.container.getPlayer(), stack));
                    } else {
                        int flags = 0;
                        if (clickedButton == 1) {
                            flags |= 1;
                        }
                        if (GuiScreen.func_146272_n()) {
                            flags |= 4;
                        }
                        if (clickedButton == 2) {
                            flags |= 2;
                        }
                        RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageGridItemPull(stack.getHash(), flags));
                    }
                } else if (this.grid.getType() == EnumGridType.FLUID && held == null) {
                    RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageGridFluidPull(STACKS.get(this.slotNumber).getHash(), GuiScreen.func_146272_n()));
                }
            }
        }
        if (clickedClear || clickedCreatePattern) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (!this.func_146983_a(keyCode)) {
            if (this.searchField.func_146201_a(character, keyCode)) {
                this.updateJEI();
                this.sortItems();
            } else {
                super.func_73869_a(character, keyCode);
            }
        }
    }

    private void updateJEI() {
        if (IntegrationJEI.isLoaded() && (this.grid.getSearchBoxMode() == 2 || this.grid.getSearchBoxMode() == 3)) {
            RefinedStorageJEIPlugin.INSTANCE.getRuntime().getItemListOverlay().setFilterText(this.searchField.func_146179_b());
        }
    }

    public void updateSearchFieldFocus(int mode) {
        if (this.searchField != null) {
            this.searchField.func_146205_d(!TileGrid.isSearchBoxModeWithAutoselection(mode));
            this.searchField.func_146195_b(TileGrid.isSearchBoxModeWithAutoselection(mode));
        }
    }
}

