/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.gui.grid.stack;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import refinedstorage.gui.GuiBase;
import refinedstorage.gui.grid.stack.IClientStack;

public class ClientStackFluid
implements IClientStack {
    private int hash;
    private FluidStack stack;

    public ClientStackFluid(ByteBuf buf) {
        this.hash = buf.readInt();
        this.stack = new FluidStack(FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)buf)), buf.readInt(), ByteBufUtils.readTag((ByteBuf)buf));
    }

    public FluidStack getStack() {
        return this.stack;
    }

    @Override
    public int getHash() {
        return this.hash;
    }

    @Override
    public String getName() {
        return this.stack.getFluid().getLocalizedName(this.stack);
    }

    @Override
    public String getModId() {
        return this.stack.getFluid().getStill(this.stack).func_110624_b();
    }

    @Override
    public String getTooltip() {
        return this.stack.getFluid().getLocalizedName(this.stack);
    }

    @Override
    public int getQuantity() {
        return this.stack.amount;
    }

    @Override
    public void draw(GuiBase gui, int x, int y, boolean isOverWithShift) {
        GuiBase.FLUID_RENDERER.draw(gui.field_146297_k, x, y, this.stack);
        gui.drawQuantity(x, y, String.format(Locale.US, "%.1f", Float.valueOf((float)this.stack.amount / 1000.0f)).replace(".0", ""));
    }

    public boolean equals(Object obj) {
        return obj instanceof ClientStackFluid && ((ClientStackFluid)obj).getStack().isFluidEqual(this.stack);
    }
}

