/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.gui.grid.stack;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import refinedstorage.gui.GuiBase;
import refinedstorage.gui.grid.stack.IClientStack;

public class ClientStackItem
implements IClientStack {
    private int hash;
    private ItemStack stack;
    private boolean craftable;

    public ClientStackItem(ByteBuf buf) {
        this.stack = new ItemStack(Item.func_150899_d((int)buf.readInt()), buf.readInt(), buf.readInt());
        this.stack.func_77982_d(ByteBufUtils.readTag((ByteBuf)buf));
        this.hash = buf.readInt();
        this.craftable = buf.readBoolean();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public int getHash() {
        return this.hash;
    }

    @Override
    public String getName() {
        return this.stack.func_82833_r();
    }

    @Override
    public String getModId() {
        return ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.stack.func_77973_b())).func_110624_b();
    }

    @Override
    public String getTooltip() {
        return Strings.join((List)this.stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x), (String)"\n");
    }

    @Override
    public int getQuantity() {
        return this.stack.field_77994_a;
    }

    private String getQuantityForDisplay(boolean advanced) {
        int qty = this.stack.field_77994_a;
        if (advanced && qty > 1) {
            return String.valueOf(qty);
        }
        if (qty >= 1000000) {
            return String.format(Locale.US, "%.1f", Float.valueOf((float)qty / 1000000.0f)).replace(".0", "") + "M";
        }
        if (qty >= 1000) {
            return String.format(Locale.US, "%.1f", Float.valueOf((float)qty / 1000.0f)).replace(".0", "") + "K";
        }
        if (qty == 1) {
            return null;
        }
        if (qty == 0) {
            return I18n.func_135052_a((String)"gui.refinedstorage:grid.craft", (Object[])new Object[0]);
        }
        return String.valueOf(qty);
    }

    @Override
    public void draw(GuiBase gui, int x, int y, boolean isOverWithShift) {
        gui.drawItem(x, y, this.stack, true, this.getQuantityForDisplay(isOverWithShift));
    }

    public boolean equals(Object obj) {
        return obj instanceof IClientStack && ((ClientStackItem)obj).getHash() == this.hash;
    }
}

