/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.inventory;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import refinedstorage.RefinedStorageItems;
import refinedstorage.gui.grid.GridFilteredItem;
import refinedstorage.gui.grid.GuiGrid;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerGridFilter;
import refinedstorage.inventory.ItemValidatorBasic;
import refinedstorage.item.ItemGridFilter;

public class ItemHandlerGridFilterInGrid
extends ItemHandlerBasic {
    private List<GridFilteredItem> filteredItems;

    public ItemHandlerGridFilterInGrid(List<GridFilteredItem> filteredItems) {
        super(4, new ItemValidatorBasic(RefinedStorageItems.GRID_FILTER));
        this.filteredItems = filteredItems;
    }

    @Override
    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.filteredItems.clear();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack filter = this.getStackInSlot(i);
            if (filter == null) continue;
            int compare = ItemGridFilter.getCompare(filter);
            ItemHandlerGridFilter items = new ItemHandlerGridFilter(filter);
            for (ItemStack item : items.getFilteredItems()) {
                if (item == null) continue;
                this.filteredItems.add(new GridFilteredItem(item, compare));
            }
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            GuiGrid.markForSorting();
        }
    }
}

