/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import refinedstorage.RefinedStorageBlocks;
import refinedstorage.RefinedStorageItems;
import refinedstorage.apiimpl.storage.item.ItemStorageNBT;
import refinedstorage.block.EnumItemStorageType;
import refinedstorage.item.ItemBlockBase;

public class ItemBlockStorage
extends ItemBlockBase {
    public ItemBlockStorage() {
        super(RefinedStorageBlocks.STORAGE, RefinedStorageBlocks.STORAGE.getPlacementType(), true);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        EnumItemStorageType type = EnumItemStorageType.getById(stack.func_77960_j());
        if (type != null && ItemBlockStorage.isValid(stack)) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("Storage");
            if (type == EnumItemStorageType.TYPE_CREATIVE) {
                tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored", (Object[])new Object[]{ItemStorageNBT.getStoredFromNBT(tag)}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored_capacity", (Object[])new Object[]{ItemStorageNBT.getStoredFromNBT(tag), type.getCapacity()}));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        EnumItemStorageType type = EnumItemStorageType.getById(stack.func_77960_j());
        if (type != null && stack.field_77994_a == 1 && ItemBlockStorage.isValid(stack) && ItemStorageNBT.getStoredFromNBT(stack.func_77978_p().func_74775_l("Storage")) == 0 && stack.func_77960_j() != 4 && !world.field_72995_K && player.func_70093_af()) {
            ItemStack processor;
            ItemStack storagePart = new ItemStack((Item)RefinedStorageItems.STORAGE_PART, 1, stack.func_77960_j());
            if (!player.field_71071_by.func_70441_a(storagePart.func_77946_l())) {
                InventoryHelper.func_180173_a((World)world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)storagePart);
            }
            if (!player.field_71071_by.func_70441_a((processor = new ItemStack((Item)RefinedStorageItems.PROCESSOR, 1, 3)).func_77946_l())) {
                InventoryHelper.func_180173_a((World)world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)processor);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Block)RefinedStorageBlocks.MACHINE_CASING));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private static boolean isValid(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Storage");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!stack.func_77942_o()) {
            ItemBlockStorage.initNBT(stack);
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        ItemBlockStorage.initNBT(stack);
    }

    public static ItemStack initNBT(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Storage", (NBTBase)ItemStorageNBT.createNBT());
        stack.func_77982_d(tag);
        return stack;
    }
}

