/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import refinedstorage.RefinedStorageBlocks;
import refinedstorage.item.ItemBase;

public class ItemNetworkCard
extends ItemBase {
    private static final String NBT_RECEIVER_X = "ReceiverX";
    private static final String NBT_RECEIVER_Y = "ReceiverY";
    private static final String NBT_RECEIVER_Z = "ReceiverZ";
    private static final String NBT_DIMENSION = "Dimension";

    public ItemNetworkCard() {
        super("network_card");
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == RefinedStorageBlocks.NETWORK_RECEIVER) {
            ItemNetworkCard.setReceiver(stack, pos, world.field_73011_w.getDimension());
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        BlockPos pos = ItemNetworkCard.getReceiver(stack);
        if (pos != null) {
            tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:network_card.tooltip", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
        }
    }

    public static BlockPos getReceiver(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_RECEIVER_X) && stack.func_77978_p().func_74764_b(NBT_RECEIVER_Y) && stack.func_77978_p().func_74764_b(NBT_RECEIVER_Z)) {
            return new BlockPos(stack.func_77978_p().func_74762_e(NBT_RECEIVER_X), stack.func_77978_p().func_74762_e(NBT_RECEIVER_Y), stack.func_77978_p().func_74762_e(NBT_RECEIVER_Z));
        }
        return null;
    }

    public static int getDimension(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_DIMENSION) ? stack.func_77978_p().func_74762_e(NBT_DIMENSION) : 0;
    }

    public static void setReceiver(ItemStack stack, BlockPos pos, int dimension) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(NBT_RECEIVER_X, pos.func_177958_n());
        tag.func_74768_a(NBT_RECEIVER_Y, pos.func_177956_o());
        tag.func_74768_a(NBT_RECEIVER_Z, pos.func_177952_p());
        tag.func_74768_a(NBT_DIMENSION, dimension);
        stack.func_77982_d(tag);
    }
}

