/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import refinedstorage.RefinedStorageItems;
import refinedstorage.apiimpl.storage.item.ItemStorageNBT;
import refinedstorage.block.EnumItemStorageType;
import refinedstorage.item.ItemBase;

public class ItemStorageDisk
extends ItemBase {
    public static final int TYPE_1K = 0;
    public static final int TYPE_4K = 1;
    public static final int TYPE_16K = 2;
    public static final int TYPE_64K = 3;
    public static final int TYPE_CREATIVE = 4;
    public static final int TYPE_DEBUG = 5;
    private NBTTagCompound debugDiskTag;

    public ItemStorageDisk() {
        super("storage_disk");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 5; ++i) {
            list.add(ItemStorageNBT.createStackWithNBT(new ItemStack(item, 1, i)));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!stack.func_77942_o()) {
            if (stack.func_77952_i() == 5) {
                this.applyDebugDiskData(stack);
            } else {
                ItemStorageNBT.createStackWithNBT(stack);
            }
        }
    }

    private void applyDebugDiskData(ItemStack stack) {
        if (this.debugDiskTag == null) {
            this.debugDiskTag = ItemStorageNBT.createNBT();
            ItemStorageNBT storage = new ItemStorageNBT(this.debugDiskTag, -1, null){

                @Override
                public int getPriority() {
                    return 0;
                }
            };
            for (Item item : Item.field_150901_e) {
                if (item == RefinedStorageItems.STORAGE_DISK) continue;
                ArrayList stacks = new ArrayList();
                item.func_150895_a(item, CreativeTabs.field_78036_m, stacks);
                for (ItemStack itemStack : stacks) {
                    storage.insertItem(itemStack, 1000, false);
                }
            }
            storage.writeToNBT();
        }
        stack.func_77982_d(this.debugDiskTag.func_74737_b());
    }

    public void func_77624_a(ItemStack disk, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (ItemStorageNBT.isValid(disk)) {
            int capacity = EnumItemStorageType.getById(disk.func_77952_i()).getCapacity();
            if (capacity == -1) {
                tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored", (Object[])new Object[]{ItemStorageNBT.getStoredFromNBT(disk.func_77978_p())}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored_capacity", (Object[])new Object[]{ItemStorageNBT.getStoredFromNBT(disk.func_77978_p()), capacity}));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack disk, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && player.func_70093_af() && ItemStorageNBT.isValid(disk) && ItemStorageNBT.getStoredFromNBT(disk.func_77978_p()) == 0 && disk.func_77960_j() != 4) {
            ItemStack storagePart = new ItemStack((Item)RefinedStorageItems.STORAGE_PART, 1, disk.func_77960_j());
            if (!player.field_71071_by.func_70441_a(storagePart.func_77946_l())) {
                InventoryHelper.func_180173_a((World)world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)storagePart);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)RefinedStorageItems.STORAGE_HOUSING));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)disk);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        ItemStorageNBT.createStackWithNBT(stack);
    }
}

