/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.gui.grid.GuiGrid;
import refinedstorage.gui.grid.stack.ClientStackFluid;

public class MessageGridFluidUpdate
implements IMessage,
IMessageHandler<MessageGridFluidUpdate, IMessage> {
    private INetworkMaster network;
    private List<ClientStackFluid> stacks = new ArrayList<ClientStackFluid>();

    public MessageGridFluidUpdate() {
    }

    public MessageGridFluidUpdate(INetworkMaster network) {
        this.network = network;
    }

    public void fromBytes(ByteBuf buf) {
        int items = buf.readInt();
        for (int i = 0; i < items; ++i) {
            this.stacks.add(new ClientStackFluid(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.network.getFluidStorage().getStacks().size());
        for (FluidStack stack : this.network.getFluidStorage().getStacks()) {
            NetworkUtils.writeFluidStack(buf, stack);
        }
    }

    public IMessage onMessage(MessageGridFluidUpdate message, MessageContext ctx) {
        GuiGrid.FLUIDS.clear();
        for (ClientStackFluid item : message.stacks) {
            GuiGrid.FLUIDS.put((Object)item.getStack().getFluid(), (Object)item);
        }
        GuiGrid.markForSorting();
        return null;
    }
}

