/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.gui.grid.GuiGrid;
import refinedstorage.gui.grid.stack.ClientStackItem;

public class MessageGridItemUpdate
implements IMessage,
IMessageHandler<MessageGridItemUpdate, IMessage> {
    private INetworkMaster network;
    private List<ClientStackItem> stacks = new ArrayList<ClientStackItem>();

    public MessageGridItemUpdate() {
    }

    public MessageGridItemUpdate(INetworkMaster network) {
        this.network = network;
    }

    public void fromBytes(ByteBuf buf) {
        int items = buf.readInt();
        for (int i = 0; i < items; ++i) {
            this.stacks.add(new ClientStackItem(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.network.getItemStorage().getStacks().size());
        for (ItemStack stack : this.network.getItemStorage().getStacks()) {
            NetworkUtils.writeItemStack(buf, this.network, stack);
        }
    }

    public IMessage onMessage(MessageGridItemUpdate message, MessageContext ctx) {
        GuiGrid.ITEMS.clear();
        for (ClientStackItem item : message.stacks) {
            GuiGrid.ITEMS.put((Object)item.getStack().func_77973_b(), (Object)item);
        }
        GuiGrid.markForSorting();
        return null;
    }
}

