/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import refinedstorage.container.ContainerGrid;
import refinedstorage.network.MessageHandlerPlayerToServer;
import refinedstorage.tile.grid.IGrid;
import refinedstorage.tile.grid.TileGrid;
import refinedstorage.tile.grid.WirelessGrid;

public class MessageWirelessGridSettingsUpdate
extends MessageHandlerPlayerToServer<MessageWirelessGridSettingsUpdate>
implements IMessage {
    private int viewType;
    private int sortingDirection;
    private int sortingType;
    private int searchBoxMode;

    public MessageWirelessGridSettingsUpdate() {
    }

    public MessageWirelessGridSettingsUpdate(int viewType, int sortingDirection, int sortingType, int searchBoxMode) {
        this.viewType = viewType;
        this.sortingDirection = sortingDirection;
        this.sortingType = sortingType;
        this.searchBoxMode = searchBoxMode;
    }

    public void fromBytes(ByteBuf buf) {
        this.viewType = buf.readInt();
        this.sortingDirection = buf.readInt();
        this.sortingType = buf.readInt();
        this.searchBoxMode = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.viewType);
        buf.writeInt(this.sortingDirection);
        buf.writeInt(this.sortingType);
        buf.writeInt(this.searchBoxMode);
    }

    @Override
    public void handle(MessageWirelessGridSettingsUpdate message, EntityPlayerMP player) {
        IGrid grid;
        if (player.field_71070_bA instanceof ContainerGrid && (grid = ((ContainerGrid)player.field_71070_bA).getGrid()) instanceof WirelessGrid) {
            ItemStack stack = ((WirelessGrid)grid).getStack();
            if (TileGrid.isValidViewType(message.viewType)) {
                stack.func_77978_p().func_74768_a("ViewType", message.viewType);
            }
            if (TileGrid.isValidSortingDirection(message.sortingDirection)) {
                stack.func_77978_p().func_74768_a("SortingDirection", message.sortingDirection);
            }
            if (TileGrid.isValidSortingType(message.sortingType)) {
                stack.func_77978_p().func_74768_a("SortingType", message.sortingType);
            }
            if (TileGrid.isValidSearchBoxMode(message.searchBoxMode)) {
                stack.func_77978_p().func_74768_a("SearchBoxMode", message.searchBoxMode);
            }
        }
    }
}

