/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidHandlerWrapper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import refinedstorage.tile.data.TileDataManager;

public abstract class TileBase
extends TileEntity
implements ITickable {
    private static final String NBT_DIRECTION = "Direction";
    private static final String NBT_INVENTORY = "Inventory_%d";
    private static final String NBT_SLOT = "Slot";
    private EnumFacing direction = EnumFacing.NORTH;
    protected TileDataManager dataManager = new TileDataManager(this);
    protected int ticks = 0;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.ticks;
            this.dataManager.detectAndSendChanges();
        }
    }

    public void updateBlock() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public void setDirection(EnumFacing direction) {
        this.direction = direction;
        this.func_70296_d();
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public TileDataManager getDataManager() {
        return this.dataManager;
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        tag.func_74768_a(NBT_DIRECTION, this.direction.ordinal());
        return tag;
    }

    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        tag.func_74768_a(NBT_DIRECTION, this.direction.ordinal());
        return tag;
    }

    public void read(NBTTagCompound tag) {
        this.direction = EnumFacing.func_82600_a((int)tag.func_74762_e(NBT_DIRECTION));
    }

    public void readUpdate(NBTTagCompound tag) {
        this.direction = EnumFacing.func_82600_a((int)tag.func_74762_e(NBT_DIRECTION));
        this.updateBlock();
    }

    public NBTTagCompound func_189517_E_() {
        return this.writeUpdate(super.func_189517_E_());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readUpdate(packet.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readUpdate(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.read(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.write(super.func_189515_b(tag));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public TileEntity getFacingTile() {
        return this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.direction));
    }

    public IItemHandler getDrops() {
        return null;
    }

    public static void writeItems(IItemHandler handler, int id, NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i) == null) continue;
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.func_74768_a(NBT_SLOT, i);
            handler.getStackInSlot(i).func_77955_b(compoundTag);
            tagList.func_74742_a((NBTBase)compoundTag);
        }
        nbt.func_74782_a(String.format(NBT_INVENTORY, id), (NBTBase)tagList);
    }

    public static void readItems(IItemHandler handler, int id, NBTTagCompound nbt) {
        String name = String.format(NBT_INVENTORY, id);
        if (nbt.func_74764_b(name)) {
            NBTTagList tagList = nbt.func_150295_c(name, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e(NBT_SLOT);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i));
                if (slot < 0 || slot >= handler.getSlots()) continue;
                handler.insertItem(slot, stack, false);
            }
        }
    }

    public static void writeItemsLegacy(IInventory inventory, int id, NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) == null) continue;
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.func_74768_a(NBT_SLOT, i);
            inventory.func_70301_a(i).func_77955_b(compoundTag);
            tagList.func_74742_a((NBTBase)compoundTag);
        }
        nbt.func_74782_a(String.format(NBT_INVENTORY, id), (NBTBase)tagList);
    }

    public static void readItemsLegacy(IInventory inventory, int id, NBTTagCompound nbt) {
        String name = String.format(NBT_INVENTORY, id);
        if (nbt.func_74764_b(name)) {
            NBTTagList tagList = nbt.func_150295_c(name, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e(NBT_SLOT);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i));
                inventory.func_70299_a(slot, stack);
            }
        }
    }

    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing side) {
        IItemHandler handler;
        if (tile == null) {
            return null;
        }
        IItemHandler iItemHandler = handler = tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) ? (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) : null;
        if (handler == null) {
            if (side != null && tile instanceof ISidedInventory) {
                handler = new SidedInvWrapper((ISidedInventory)tile, side);
            } else if (tile instanceof IInventory) {
                handler = new InvWrapper((IInventory)tile);
            }
        }
        return handler;
    }

    protected IFluidHandler getFluidHandler(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        IFluidHandler handler = null;
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        } else if (tile instanceof net.minecraftforge.fluids.IFluidHandler) {
            handler = new FluidHandlerWrapper((net.minecraftforge.fluids.IFluidHandler)tile, side);
        }
        return handler;
    }

    public boolean equals(Object o) {
        return o instanceof TileBase && ((TileBase)((Object)o)).func_174877_v().equals((Object)this.field_174879_c) && ((TileBase)((Object)o)).func_145831_w().field_73011_w.getDimension() == this.field_145850_b.field_73011_w.getDimension();
    }

    public int hashCode() {
        int result = this.field_174879_c.hashCode();
        result = 31 * result + this.field_145850_b.field_73011_w.getDimension();
        return result;
    }
}

