/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import mcmultipart.microblock.IMicroblock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.RefinedStorage;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.container.slot.SlotSpecimen;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerFluid;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.tile.TileMultipartNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.IType;
import refinedstorage.tile.data.TileDataParameter;

public class TileConstructor
extends TileMultipartNode
implements IComparable,
IType {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> TYPE = IType.createParameter();
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final int BASE_SPEED = 20;
    private ItemHandlerBasic itemFilters = new ItemHandlerBasic(1, this, new IItemValidator[0]){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileConstructor.this.block = SlotSpecimen.getBlockState((IBlockAccess)TileConstructor.this.field_145850_b, TileConstructor.this.field_174879_c.func_177972_a(TileConstructor.this.getDirection()), this.getStackInSlot(0));
        }
    };
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(1, this);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2, 3);
    private int compare = 0;
    private int type = 0;
    private IBlockState block;

    public TileConstructor() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(TYPE);
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return !TileConstructor.isBlockingMicroblock(microblock, this.getDirection());
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.config.constructorUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        if (this.ticks % this.upgrades.getSpeed(20, 4) == 0) {
            FluidStack stack;
            if (this.type == 0 && this.block != null) {
                BlockPos front = this.field_174879_c.func_177972_a(this.getDirection());
                if (this.field_145850_b.func_175623_d(front) && this.block.func_177230_c().func_176196_c(this.field_145850_b, front)) {
                    ItemStack took = this.network.extractItem(this.itemFilters.getStackInSlot(0), 1, this.compare);
                    if (took != null) {
                        IBlockState state = this.block.func_177230_c().func_176203_a(took.func_77960_j());
                        this.field_145850_b.func_180501_a(front, state, 3);
                        SoundType blockSound = this.block.func_177230_c().getSoundType(state, this.field_145850_b, this.field_174879_c, null);
                        this.field_145850_b.func_184133_a(null, front, blockSound.func_185841_e(), SoundCategory.BLOCKS, (blockSound.func_185843_a() + 1.0f) / 2.0f, blockSound.func_185847_b() * 0.8f);
                    } else if (this.upgrades.hasUpgrade(3)) {
                        ItemStack craft = this.itemFilters.getStackInSlot(0);
                        NetworkUtils.scheduleCraftingTaskIfUnscheduled(this.network, craft, 1, this.compare);
                    }
                }
            } else if (this.type == 1 && (stack = this.fluidFilters.getFluidStackInSlot(0)) != null && stack.getFluid().canBePlacedInWorld()) {
                FluidStack took;
                BlockPos front = this.field_174879_c.func_177972_a(this.getDirection());
                Block block = stack.getFluid().getBlock();
                if (this.field_145850_b.func_175623_d(front) && block.func_176196_c(this.field_145850_b, front) && (took = this.network.extractFluid(stack, 1000, this.compare)) != null) {
                    IBlockState state = block.func_176223_P();
                    if (state.func_177230_c() == Blocks.field_150355_j) {
                        state = Blocks.field_150358_i.func_176223_P();
                    } else if (state.func_177230_c() == Blocks.field_150353_l) {
                        state = Blocks.field_150356_k.func_176223_P();
                    }
                    this.field_145850_b.func_180501_a(front, state, 3);
                }
            }
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        TileConstructor.readItems((IItemHandler)this.itemFilters, 0, tag);
        TileConstructor.readItems((IItemHandler)this.upgrades, 1, tag);
        TileConstructor.readItems((IItemHandler)this.fluidFilters, 2, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        TileConstructor.writeItems((IItemHandler)this.itemFilters, 0, tag);
        TileConstructor.writeItems((IItemHandler)this.upgrades, 1, tag);
        TileConstructor.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        return tag;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public int getType() {
        return this.field_145850_b.field_72995_K ? TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.func_70296_d();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.upgrades);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

