/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.RefinedStorage;
import refinedstorage.RefinedStorageBlocks;
import refinedstorage.api.RefinedStorageAPI;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.autocrafting.ICraftingPatternContainer;
import refinedstorage.api.autocrafting.ICraftingPatternProvider;
import refinedstorage.api.autocrafting.registry.ICraftingTaskFactory;
import refinedstorage.api.autocrafting.task.ICraftingTask;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.INetworkNode;
import refinedstorage.api.network.INetworkNodeGraph;
import refinedstorage.api.network.IWirelessGridHandler;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.api.network.grid.IFluidGridHandler;
import refinedstorage.api.network.grid.IItemGridHandler;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.api.storage.fluid.IFluidStorage;
import refinedstorage.api.storage.fluid.IGroupedFluidStorage;
import refinedstorage.api.storage.item.IGroupedItemStorage;
import refinedstorage.api.storage.item.IItemStorage;
import refinedstorage.apiimpl.autocrafting.task.CraftingTaskProcessing;
import refinedstorage.apiimpl.network.NetworkNodeGraph;
import refinedstorage.apiimpl.network.WirelessGridHandler;
import refinedstorage.apiimpl.network.grid.FluidGridHandler;
import refinedstorage.apiimpl.network.grid.ItemGridHandler;
import refinedstorage.apiimpl.storage.fluid.FluidUtils;
import refinedstorage.apiimpl.storage.fluid.GroupedFluidStorage;
import refinedstorage.apiimpl.storage.item.GroupedItemStorage;
import refinedstorage.block.BlockController;
import refinedstorage.block.EnumControllerType;
import refinedstorage.block.EnumGridType;
import refinedstorage.container.ContainerGrid;
import refinedstorage.integration.forgeenergy.ControllerEnergyForge;
import refinedstorage.integration.ic2.ControllerEnergyIC2;
import refinedstorage.integration.ic2.ControllerEnergyIC2None;
import refinedstorage.integration.ic2.IControllerEnergyIC2;
import refinedstorage.integration.ic2.IntegrationIC2;
import refinedstorage.integration.tesla.ControllerEnergyTesla;
import refinedstorage.integration.tesla.IntegrationTesla;
import refinedstorage.network.MessageGridFluidDelta;
import refinedstorage.network.MessageGridFluidUpdate;
import refinedstorage.network.MessageGridItemDelta;
import refinedstorage.network.MessageGridItemUpdate;
import refinedstorage.tile.ClientNode;
import refinedstorage.tile.TileBase;
import refinedstorage.tile.TileCraftingMonitor;
import refinedstorage.tile.config.IRedstoneConfigurable;
import refinedstorage.tile.config.RedstoneMode;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.RefinedStorageSerializers;
import refinedstorage.tile.data.TileDataParameter;
import refinedstorage.tile.externalstorage.FluidStorageExternal;
import refinedstorage.tile.externalstorage.ItemStorageExternal;
import refinedstorage.tile.grid.IGrid;

public class TileController
extends TileBase
implements INetworkMaster,
IEnergyReceiver,
IRedstoneConfigurable {
    public static final TileDataParameter<Integer> REDSTONE_MODE = RedstoneMode.createParameter();
    public static final TileDataParameter<Integer> ENERGY_USAGE = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileController>(){

        @Override
        public Integer getValue(TileController tile) {
            return tile.getEnergyUsage();
        }
    });
    public static final TileDataParameter<Integer> ENERGY_STORED = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileController>(){

        @Override
        public Integer getValue(TileController tile) {
            return tile.getEnergy().getEnergyStored();
        }
    });
    public static final TileDataParameter<Integer> ENERGY_CAPACITY = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileController>(){

        @Override
        public Integer getValue(TileController tile) {
            return tile.getEnergy().getMaxEnergyStored();
        }
    });
    public static final TileDataParameter<List<ClientNode>> NODES = new TileDataParameter<List<ClientNode>>(RefinedStorageSerializers.CLIENT_NODE_SERIALIZER, new ArrayList(), new ITileDataProducer<List<ClientNode>, TileController>(){

        @Override
        public List<ClientNode> getValue(TileController tile) {
            ArrayList<ClientNode> nodes = new ArrayList<ClientNode>();
            block0: for (INetworkNode node : tile.nodeGraph.all()) {
                IBlockState state;
                ClientNode clientNode;
                if (!node.canUpdate() || (clientNode = new ClientNode(new ItemStack((state = tile.field_145850_b.func_180495_p(node.getPosition())).func_177230_c(), 1, state.func_177230_c().func_176201_c(state)), 1, node.getEnergyUsage())).getStack().func_77973_b() == null) continue;
                if (nodes.contains(clientNode)) {
                    for (ClientNode other : nodes) {
                        if (!other.equals(clientNode)) continue;
                        other.setAmount(other.getAmount() + 1);
                        continue block0;
                    }
                    continue;
                }
                nodes.add(clientNode);
            }
            return nodes;
        }
    });
    public static final String NBT_ENERGY = "Energy";
    public static final String NBT_ENERGY_CAPACITY = "EnergyCapacity";
    private static final String NBT_CRAFTING_TASKS = "CraftingTasks";
    private static final Comparator<IItemStorage> ITEM_SIZE_COMPARATOR = (left, right) -> {
        if (left.getStored() == right.getStored()) {
            return 0;
        }
        return left.getStored() > right.getStored() ? -1 : 1;
    };
    private static final Comparator<IItemStorage> ITEM_PRIORITY_COMPARATOR = (left, right) -> {
        if (left.getPriority() == right.getPriority()) {
            return 0;
        }
        return left.getPriority() > right.getPriority() ? -1 : 1;
    };
    private static final Comparator<IFluidStorage> FLUID_SIZE_COMPARATOR = (left, right) -> {
        if (left.getStored() == right.getStored()) {
            return 0;
        }
        return left.getStored() > right.getStored() ? -1 : 1;
    };
    private static final Comparator<IFluidStorage> FLUID_PRIORITY_COMPARATOR = (left, right) -> {
        if (left.getPriority() == right.getPriority()) {
            return 0;
        }
        return left.getPriority() > right.getPriority() ? -1 : 1;
    };
    private IItemGridHandler itemGridHandler = new ItemGridHandler(this);
    private IFluidGridHandler fluidGridHandler = new FluidGridHandler(this);
    private IWirelessGridHandler wirelessGridHandler = new WirelessGridHandler(this);
    private INetworkNodeGraph nodeGraph = new NetworkNodeGraph(this);
    private IGroupedItemStorage itemStorage = new GroupedItemStorage(this);
    private IGroupedFluidStorage fluidStorage = new GroupedFluidStorage(this);
    private List<ICraftingPattern> patterns = new ArrayList<ICraftingPattern>();
    private List<ICraftingTask> craftingTasks = new ArrayList<ICraftingTask>();
    private List<ICraftingTask> craftingTasksToAdd = new ArrayList<ICraftingTask>();
    private List<ICraftingTask> craftingTasksToCancel = new ArrayList<ICraftingTask>();
    private List<NBTTagCompound> craftingTasksToRead = new ArrayList<NBTTagCompound>();
    private EnergyStorage energy;
    private ControllerEnergyForge energyForge;
    private IControllerEnergyIC2 energyEU;
    private ControllerEnergyTesla energyTesla;
    private int lastEnergyDisplay;
    private boolean couldRun;
    private EnumControllerType type;
    private RedstoneMode redstoneMode;

    public TileController() {
        this.energy = new EnergyStorage(RefinedStorage.INSTANCE.config.controllerCapacity);
        this.energyForge = new ControllerEnergyForge(this);
        this.redstoneMode = RedstoneMode.IGNORE;
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
        this.dataManager.addWatchedParameter(ENERGY_USAGE);
        this.dataManager.addWatchedParameter(ENERGY_STORED);
        this.dataManager.addParameter(ENERGY_CAPACITY);
        this.dataManager.addParameter(NODES);
        this.energyEU = IntegrationIC2.isLoaded() ? new ControllerEnergyIC2(this) : new ControllerEnergyIC2None();
        if (IntegrationTesla.isLoaded()) {
            this.energyTesla = new ControllerEnergyTesla(this.energy);
        }
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public EnergyStorage getEnergy() {
        return this.energy;
    }

    @Override
    public boolean canRun() {
        return this.energy.getEnergyStored() > 0 && this.redstoneMode.isEnabled(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public INetworkNodeGraph getNodeGraph() {
        return this.nodeGraph;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.energyEU.update();
            if (!this.craftingTasksToRead.isEmpty()) {
                for (NBTTagCompound nBTTagCompound : this.craftingTasksToRead) {
                    ICraftingTask task2 = TileController.readCraftingTask(this.field_145850_b, nBTTagCompound);
                    if (task2 == null) continue;
                    this.addCraftingTask(task2);
                }
                this.craftingTasksToRead.clear();
            }
            if (this.canRun()) {
                Collections.sort(this.itemStorage.getStorages(), ITEM_SIZE_COMPARATOR);
                Collections.sort(this.itemStorage.getStorages(), ITEM_PRIORITY_COMPARATOR);
                Collections.sort(this.fluidStorage.getStorages(), FLUID_SIZE_COMPARATOR);
                Collections.sort(this.fluidStorage.getStorages(), FLUID_PRIORITY_COMPARATOR);
                boolean craftingTasksChanged = !this.craftingTasksToAdd.isEmpty() || !this.craftingTasksToCancel.isEmpty();
                for (ICraftingTask taskToCancel : this.craftingTasksToCancel) {
                    taskToCancel.onCancelled(this);
                }
                this.craftingTasks.removeAll(this.craftingTasksToCancel);
                this.craftingTasksToCancel.clear();
                for (ICraftingTask task : this.craftingTasksToAdd) {
                    this.craftingTasks.add(task);
                }
                this.craftingTasksToAdd.clear();
                Iterator<ICraftingTask> iterator = this.craftingTasks.iterator();
                while (iterator.hasNext()) {
                    ICraftingTask task;
                    task = iterator.next();
                    if (!this.updateCraftingTask(task)) continue;
                    iterator.remove();
                    craftingTasksChanged = true;
                }
                if (!this.craftingTasks.isEmpty() || craftingTasksChanged) {
                    this.func_70296_d();
                    this.updateCraftingTasks();
                }
            }
            this.wirelessGridHandler.update();
            if (this.getType() == EnumControllerType.NORMAL) {
                if (!RefinedStorage.INSTANCE.config.controllerUsesEnergy) {
                    this.energy.setEnergyStored(this.energy.getMaxEnergyStored());
                } else if (this.energy.getEnergyStored() - this.getEnergyUsage() >= 0) {
                    this.energy.extractEnergy(this.getEnergyUsage(), false);
                } else {
                    this.energy.setEnergyStored(0);
                }
            } else if (this.getType() == EnumControllerType.CREATIVE) {
                this.energy.setEnergyStored(this.energy.getMaxEnergyStored());
            }
            if (this.couldRun != this.canRun()) {
                this.couldRun = this.canRun();
                NetworkUtils.rebuildGraph(this);
            }
            if (this.getEnergyScaledForDisplay() != this.lastEnergyDisplay) {
                this.lastEnergyDisplay = this.getEnergyScaledForDisplay();
                this.updateBlock();
            }
        }
        super.func_73660_a();
    }

    private boolean updateCraftingTask(ICraftingTask task) {
        if (task.getChild() != null) {
            if (this.updateCraftingTask(task.getChild())) {
                task.setChild(null);
            }
            return false;
        }
        ICraftingPatternContainer container = task.getPattern().getContainer();
        return container != null && this.ticks % container.getSpeed() == 0 && task.update(this.field_145850_b, this);
    }

    public void updateCraftingTasks() {
        for (INetworkNode node : this.nodeGraph.all()) {
            if (!(node instanceof TileCraftingMonitor)) continue;
            ((TileCraftingMonitor)node).dataManager.sendParameterToWatchers(TileCraftingMonitor.TASKS);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.energyEU.invalidate();
    }

    @Override
    public IItemGridHandler getItemGridHandler() {
        return this.itemGridHandler;
    }

    @Override
    public IFluidGridHandler getFluidGridHandler() {
        return this.fluidGridHandler;
    }

    @Override
    public IWirelessGridHandler getWirelessGridHandler() {
        return this.wirelessGridHandler;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.energyEU.onChunkUnload();
    }

    public void onDestroyed() {
        this.nodeGraph.disconnectAll();
    }

    @Override
    public IGroupedItemStorage getItemStorage() {
        return this.itemStorage;
    }

    @Override
    public IGroupedFluidStorage getFluidStorage() {
        return this.fluidStorage;
    }

    @Override
    public List<ICraftingTask> getCraftingTasks() {
        return this.craftingTasks;
    }

    @Override
    public void addCraftingTask(ICraftingTask task) {
        this.craftingTasksToAdd.add(task);
        this.func_70296_d();
    }

    @Override
    public void cancelCraftingTask(ICraftingTask task) {
        this.craftingTasksToCancel.add(task);
        this.func_70296_d();
    }

    @Override
    public List<ICraftingPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public List<ICraftingPattern> getPatterns(ItemStack pattern, int flags) {
        ArrayList<ICraftingPattern> patterns = new ArrayList<ICraftingPattern>();
        for (ICraftingPattern craftingPattern : this.getPatterns()) {
            for (ItemStack output : craftingPattern.getOutputs()) {
                if (!CompareUtils.compareStack(output, pattern, flags)) continue;
                patterns.add(craftingPattern);
            }
        }
        return patterns;
    }

    @Override
    public ICraftingPattern getPattern(ItemStack pattern, int flags) {
        List<ICraftingPattern> patterns = this.getPatterns(pattern, flags);
        if (patterns.isEmpty()) {
            return null;
        }
        if (patterns.size() == 1) {
            return patterns.get(0);
        }
        int highestScore = 0;
        int highestPattern = 0;
        for (int i = 0; i < patterns.size(); ++i) {
            int score = 0;
            for (ItemStack input : patterns.get(i).getInputs()) {
                ItemStack stored = this.itemStorage.get(input, 3);
                score += stored != null ? stored.field_77994_a : 0;
            }
            if (score <= highestScore) continue;
            highestScore = score;
            highestPattern = i;
        }
        return patterns.get(highestPattern);
    }

    @Override
    public void rebuildPatterns() {
        this.patterns.clear();
        for (INetworkNode node : this.nodeGraph.all()) {
            if (!(node instanceof ICraftingPatternContainer) || !node.canUpdate()) continue;
            this.patterns.addAll(((ICraftingPatternContainer)((Object)node)).getPatterns());
        }
        this.itemStorage.rebuild();
    }

    @Override
    public void sendItemStorageToClient() {
        this.field_145850_b.func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> this.isWatchingGrid((EntityPlayer)player, EnumGridType.NORMAL, EnumGridType.CRAFTING, EnumGridType.PATTERN)).forEach(this::sendItemStorageToClient);
    }

    @Override
    public void sendItemStorageToClient(EntityPlayerMP player) {
        RefinedStorage.INSTANCE.network.sendTo((IMessage)new MessageGridItemUpdate(this), player);
    }

    @Override
    public void sendItemStorageDeltaToClient(ItemStack stack, int delta) {
        this.field_145850_b.func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> this.isWatchingGrid((EntityPlayer)player, EnumGridType.NORMAL, EnumGridType.CRAFTING, EnumGridType.PATTERN)).forEach(player -> RefinedStorage.INSTANCE.network.sendTo((IMessage)new MessageGridItemDelta(this, stack, delta), player));
    }

    @Override
    public void sendFluidStorageToClient() {
        this.field_145850_b.func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> this.isWatchingGrid((EntityPlayer)player, EnumGridType.FLUID)).forEach(this::sendFluidStorageToClient);
    }

    @Override
    public void sendFluidStorageToClient(EntityPlayerMP player) {
        RefinedStorage.INSTANCE.network.sendTo((IMessage)new MessageGridFluidUpdate(this), player);
    }

    @Override
    public void sendFluidStorageDeltaToClient(FluidStack stack, int delta) {
        this.field_145850_b.func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> this.isWatchingGrid((EntityPlayer)player, EnumGridType.FLUID)).forEach(player -> RefinedStorage.INSTANCE.network.sendTo((IMessage)new MessageGridFluidDelta(stack, delta), player));
    }

    private boolean isWatchingGrid(EntityPlayer player, EnumGridType ... types) {
        IGrid grid;
        if (player.field_71070_bA.getClass() == ContainerGrid.class && this.field_174879_c.equals((Object)(grid = ((ContainerGrid)player.field_71070_bA).getGrid()).getNetworkPosition())) {
            return Arrays.asList(types).contains((Object)grid.getType());
        }
        return false;
    }

    @Override
    public ItemStack insertItem(ItemStack stack, int size, boolean simulate) {
        int inserted;
        if (stack == null || stack.func_77973_b() == null || this.itemStorage.getStorages().isEmpty()) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
        }
        int orginalSize = size;
        ItemStack remainder = stack;
        for (IItemStorage storage : this.itemStorage.getStorages()) {
            remainder = storage.insertItem(remainder, size, simulate);
            if (storage instanceof ItemStorageExternal && !simulate) {
                ((ItemStorageExternal)storage).updateCacheForcefully();
            }
            if (remainder == null) break;
            size = remainder.field_77994_a;
        }
        int n = inserted = remainder != null ? orginalSize - remainder.field_77994_a : orginalSize;
        if (!simulate && inserted > 0) {
            this.itemStorage.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)inserted), false);
            block1: for (int i = 0; i < inserted; ++i) {
                for (ICraftingTask task : this.craftingTasks) {
                    if (inserted == 0) continue block1;
                    if (!this.checkProcessing(stack, task)) continue;
                    --inserted;
                }
            }
        }
        return remainder;
    }

    private boolean checkProcessing(ItemStack stack, ICraftingTask task) {
        if (task.getChild() != null) {
            return this.checkProcessing(stack, task.getChild());
        }
        return task instanceof CraftingTaskProcessing && ((CraftingTaskProcessing)task).onInserted(stack);
    }

    @Override
    public ItemStack extractItem(ItemStack stack, int size, int flags) {
        int requested = size;
        int received = 0;
        ItemStack newStack = null;
        for (IItemStorage storage : this.itemStorage.getStorages()) {
            ItemStack took = storage.extractItem(stack, requested - received, flags);
            if (took != null) {
                if (storage instanceof ItemStorageExternal) {
                    ((ItemStorageExternal)storage).updateCacheForcefully();
                }
                if (newStack == null) {
                    newStack = took;
                } else {
                    newStack.field_77994_a += took.field_77994_a;
                }
                received += took.field_77994_a;
            }
            if (requested != received) continue;
            break;
        }
        if (newStack != null) {
            this.itemStorage.remove(newStack);
        }
        return newStack;
    }

    @Override
    @Nullable
    public FluidStack insertFluid(@Nonnull FluidStack stack, int size, boolean simulate) {
        int inserted;
        if (stack == null || this.fluidStorage.getStorages().isEmpty()) {
            return FluidUtils.copyStackWithSize(stack, size);
        }
        int orginalSize = size;
        FluidStack remainder = stack;
        for (IFluidStorage storage : this.fluidStorage.getStorages()) {
            remainder = storage.insertFluid(remainder, size, simulate);
            if (storage instanceof FluidStorageExternal && !simulate) {
                ((FluidStorageExternal)storage).updateCacheForcefully();
            }
            if (remainder == null) break;
            size = remainder.amount;
        }
        int n = inserted = remainder != null ? orginalSize - remainder.amount : orginalSize;
        if (!simulate && inserted > 0) {
            this.fluidStorage.add(FluidUtils.copyStackWithSize(stack, inserted), false);
        }
        return remainder;
    }

    @Override
    @Nullable
    public FluidStack extractFluid(@Nonnull FluidStack stack, int size, int flags) {
        int requested = size;
        int received = 0;
        FluidStack newStack = null;
        for (IFluidStorage storage : this.fluidStorage.getStorages()) {
            FluidStack took = storage.extractFluid(stack, requested - received, flags);
            if (took != null) {
                if (storage instanceof FluidStorageExternal) {
                    ((FluidStorageExternal)storage).updateCacheForcefully();
                }
                if (newStack == null) {
                    newStack = took;
                } else {
                    newStack.amount += took.amount;
                }
                received += took.amount;
            }
            if (requested != received) continue;
            break;
        }
        if (newStack != null) {
            this.fluidStorage.remove(newStack);
        }
        return newStack;
    }

    @Override
    public World getNetworkWorld() {
        return this.field_145850_b;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy.readFromNBT(tag);
        this.redstoneMode = RedstoneMode.read(tag);
        if (tag.func_74764_b(NBT_CRAFTING_TASKS)) {
            NBTTagList taskList = tag.func_150295_c(NBT_CRAFTING_TASKS, 10);
            for (int i = 0; i < taskList.func_74745_c(); ++i) {
                this.craftingTasksToRead.add(taskList.func_150305_b(i));
            }
        }
    }

    public static ICraftingTask readCraftingTask(World world, NBTTagCompound tag) {
        TileEntity container;
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Pattern"));
        if (stack != null && stack.func_77973_b() instanceof ICraftingPatternProvider && (container = world.func_175625_s(BlockPos.func_177969_a((long)tag.func_74763_f("Container")))) instanceof ICraftingPatternContainer) {
            ICraftingPattern pattern = ((ICraftingPatternProvider)stack.func_77973_b()).create(world, stack, (ICraftingPatternContainer)container);
            ICraftingTaskFactory factory = RefinedStorageAPI.instance().getCraftingTaskRegistry().getFactory(tag.func_74779_i("Type"));
            if (factory != null) {
                return factory.create(world, tag, pattern);
            }
        }
        return null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.energy.writeToNBT(tag);
        this.redstoneMode.write(tag);
        NBTTagList list = new NBTTagList();
        for (ICraftingTask task : this.craftingTasks) {
            list.func_74742_a((NBTBase)task.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a(NBT_CRAFTING_TASKS, (NBTBase)list);
        return tag;
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74768_a(NBT_ENERGY_CAPACITY, this.energy.getMaxEnergyStored());
        tag.func_74768_a(NBT_ENERGY, this.energy.getEnergyStored());
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        this.energy.setCapacity(tag.func_74762_e(NBT_ENERGY_CAPACITY));
        this.energy.setEnergyStored(tag.func_74762_e(NBT_ENERGY));
        super.readUpdate(tag);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energy.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    public static int getEnergyScaled(int stored, int capacity, int scale) {
        return (int)((float)stored / (float)capacity * (float)scale);
    }

    public int getEnergyScaledForDisplay() {
        return TileController.getEnergyScaled(this.energy.getEnergyStored(), this.energy.getMaxEnergyStored(), 7);
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.func_70296_d();
    }

    @Override
    public int getEnergyUsage() {
        int usage = RefinedStorage.INSTANCE.config.controllerBaseUsage;
        for (INetworkNode node : this.nodeGraph.all()) {
            if (!node.canUpdate()) continue;
            usage += node.getEnergyUsage();
        }
        return usage;
    }

    public EnumControllerType getType() {
        if (this.type == null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == RefinedStorageBlocks.CONTROLLER) {
            this.type = (EnumControllerType)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockController.TYPE));
        }
        return this.type == null ? EnumControllerType.NORMAL : this.type;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyForge;
        }
        if (this.energyTesla != null && (capability == TeslaCapabilities.CAPABILITY_HOLDER || capability == TeslaCapabilities.CAPABILITY_CONSUMER)) {
            return (T)this.energyTesla;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || this.energyTesla != null && (capability == TeslaCapabilities.CAPABILITY_HOLDER || capability == TeslaCapabilities.CAPABILITY_CONSUMER) || super.hasCapability(capability, facing);
    }
}

