/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import refinedstorage.RefinedStorage;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.autocrafting.ICraftingPatternContainer;
import refinedstorage.api.autocrafting.ICraftingPatternProvider;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.tile.TileNode;
import refinedstorage.tile.data.ITileDataConsumer;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.TileDataParameter;

public class TileCrafter
extends TileNode
implements ICraftingPatternContainer {
    public static final TileDataParameter<Boolean> TRIGGERED_AUTOCRAFTING = new TileDataParameter<Boolean>(DataSerializers.field_187198_h, false, new ITileDataProducer<Boolean, TileCrafter>(){

        @Override
        public Boolean getValue(TileCrafter tile) {
            return tile.triggeredAutocrafting;
        }
    }, new ITileDataConsumer<Boolean, TileCrafter>(){

        @Override
        public void setValue(TileCrafter tile, Boolean value) {
            tile.triggeredAutocrafting = value;
            tile.func_70296_d();
        }
    });
    private static final String NBT_TRIGGERED_AUTOCRAFTING = "TriggeredAutocrafting";
    private ItemHandlerBasic patterns = new ItemHandlerBasic(9, this, new IItemValidator[]{stack -> stack.func_77973_b() instanceof ICraftingPatternProvider}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (TileCrafter.this.field_145850_b != null && !((TileCrafter)TileCrafter.this).field_145850_b.field_72995_K) {
                TileCrafter.this.rebuildPatterns();
            }
            if (TileCrafter.this.network != null) {
                TileCrafter.this.network.rebuildPatterns();
            }
        }
    };
    private List<ICraftingPattern> actualPatterns = new ArrayList<ICraftingPattern>();
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2);
    private boolean triggeredAutocrafting = false;

    public TileCrafter() {
        this.dataManager.addWatchedParameter(TRIGGERED_AUTOCRAFTING);
    }

    private void rebuildPatterns() {
        this.actualPatterns.clear();
        for (int i = 0; i < this.patterns.getSlots(); ++i) {
            ICraftingPattern pattern;
            ItemStack patternStack = this.patterns.getStackInSlot(i);
            if (patternStack == null || !(pattern = ((ICraftingPatternProvider)patternStack.func_77973_b()).create(this.field_145850_b, patternStack, this)).isValid()) continue;
            this.actualPatterns.add(pattern);
        }
    }

    @Override
    public int getEnergyUsage() {
        int usage = RefinedStorage.INSTANCE.config.crafterUsage + this.upgrades.getEnergyUsage();
        for (int i = 0; i < this.patterns.getSlots(); ++i) {
            if (this.patterns.getStackInSlot(i) == null) continue;
            usage += RefinedStorage.INSTANCE.config.crafterPerPatternUsage;
        }
        return usage;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.ticks == 0) {
            this.rebuildPatterns();
        }
        super.func_73660_a();
    }

    @Override
    public void updateNode() {
        if (this.triggeredAutocrafting && this.field_145850_b.func_175640_z(this.field_174879_c)) {
            for (ICraftingPattern pattern : this.actualPatterns) {
                for (ItemStack output : pattern.getOutputs()) {
                    NetworkUtils.scheduleCraftingTaskIfUnscheduled(this.network, output, 1, 3);
                }
            }
        }
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        if (!state) {
            network.getCraftingTasks().stream().filter(task -> task.getPattern().getContainer().getPosition().equals((Object)this.field_174879_c)).forEach(network::cancelCraftingTask);
        }
        network.rebuildPatterns();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_TRIGGERED_AUTOCRAFTING)) {
            this.triggeredAutocrafting = tag.func_74767_n(NBT_TRIGGERED_AUTOCRAFTING);
        }
        TileCrafter.readItems((IItemHandler)this.patterns, 0, tag);
        TileCrafter.readItems((IItemHandler)this.upgrades, 1, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74757_a(NBT_TRIGGERED_AUTOCRAFTING, this.triggeredAutocrafting);
        TileCrafter.writeItems((IItemHandler)this.patterns, 0, tag);
        TileCrafter.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public int getSpeed() {
        return 20 - this.upgrades.getUpgradeCount(2) * 4;
    }

    @Override
    public IItemHandler getFacingInventory() {
        return TileCrafter.getItemHandler(this.getFacingTile(), this.getDirection().func_176734_d());
    }

    @Override
    public List<ICraftingPattern> getPatterns() {
        return this.actualPatterns;
    }

    public IItemHandler getPatternItems() {
        return this.patterns;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.patterns, this.upgrades});
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != this.getDirection()) {
            return (T)((Object)this.patterns);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != this.getDirection() || super.hasCapability(capability, facing);
    }
}

