/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import java.util.List;
import mcmultipart.microblock.IMicroblock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.RefinedStorage;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerFluid;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.tile.TileMultipartNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.config.IType;
import refinedstorage.tile.data.TileDataParameter;

public class TileDestructor
extends TileMultipartNode
implements IComparable,
IFilterable,
IType {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer> TYPE = IType.createParameter();
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final int BASE_SPEED = 20;
    private ItemHandlerBasic itemFilters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, this);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2);
    private int compare = 0;
    private int mode = 0;
    private int type = 0;

    public TileDestructor() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(TYPE);
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return !TileDestructor.isBlockingMicroblock(microblock, this.getDirection());
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.config.destructorUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        if (this.ticks % this.upgrades.getSpeed(20, 4) == 0) {
            if (this.type == 0) {
                BlockPos front = this.field_174879_c.func_177972_a(this.getDirection());
                IBlockState frontBlockState = this.field_145850_b.func_180495_p(front);
                ItemStack frontStack = frontBlockState.func_177230_c().func_185473_a(this.field_145850_b, front, frontBlockState);
                if (frontStack != null && IFilterable.canTake((IItemHandler)this.itemFilters, this.mode, this.compare, frontStack)) {
                    List drops = frontBlockState.func_177230_c().getDrops((IBlockAccess)this.field_145850_b, front, frontBlockState, 0);
                    this.field_145850_b.func_180498_a(null, 2001, front, Block.func_176210_f((IBlockState)frontBlockState));
                    this.field_145850_b.func_175698_g(front);
                    for (ItemStack drop : drops) {
                        if (this.network == null) {
                            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)front.func_177958_n(), (double)front.func_177956_o(), (double)front.func_177952_p(), (ItemStack)drop);
                            continue;
                        }
                        ItemStack remainder = this.network.insertItem(drop, drop.field_77994_a, false);
                        if (remainder == null) continue;
                        InventoryHelper.func_180173_a((World)this.field_145850_b, (double)front.func_177958_n(), (double)front.func_177956_o(), (double)front.func_177952_p(), (ItemStack)remainder);
                    }
                }
            } else if (this.type == 1) {
                FluidStack stack;
                BlockPos front = this.field_174879_c.func_177972_a(this.getDirection());
                Block frontBlock = this.field_145850_b.func_180495_p(front).func_177230_c();
                BlockLiquidWrapper handler = null;
                if (frontBlock instanceof BlockLiquid) {
                    handler = new BlockLiquidWrapper((BlockLiquid)frontBlock, this.field_145850_b, front);
                } else if (frontBlock instanceof IFluidBlock) {
                    handler = new FluidBlockWrapper((IFluidBlock)frontBlock, this.field_145850_b, front);
                }
                if (handler != null && (stack = handler.drain(1000, false)) != null && IFilterable.canTakeFluids(this.fluidFilters, this.mode, this.compare, stack) && this.network.insertFluid(stack, stack.amount, true) == null) {
                    FluidStack drained = handler.drain(1000, true);
                    this.network.insertFluid(drained, drained.amount, false);
                }
            }
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        TileDestructor.readItems((IItemHandler)this.itemFilters, 0, tag);
        TileDestructor.readItems((IItemHandler)this.upgrades, 1, tag);
        TileDestructor.readItems((IItemHandler)this.fluidFilters, 2, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        TileDestructor.writeItems((IItemHandler)this.itemFilters, 0, tag);
        TileDestructor.writeItems((IItemHandler)this.upgrades, 1, tag);
        TileDestructor.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        return tag;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getInventory() {
        return this.itemFilters;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public int getType() {
        return this.field_145850_b.field_72995_K ? TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.func_70296_d();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.upgrades);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

