/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.RefinedStorage;
import refinedstorage.RefinedStorageBlocks;
import refinedstorage.api.autocrafting.task.ICraftingTask;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.gui.GuiDetector;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerFluid;
import refinedstorage.tile.TileNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.IType;
import refinedstorage.tile.config.RedstoneMode;
import refinedstorage.tile.data.ITileDataConsumer;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.TileDataParameter;

public class TileDetector
extends TileNode
implements IComparable,
IType {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> TYPE = IType.createParameter();
    public static final TileDataParameter<Integer> MODE = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileDetector>(){

        @Override
        public Integer getValue(TileDetector tile) {
            return tile.mode;
        }
    }, new ITileDataConsumer<Integer, TileDetector>(){

        @Override
        public void setValue(TileDetector tile, Integer value) {
            if (value == 0 || value == 1 || value == 2 || value == 3) {
                tile.mode = value;
                tile.func_70296_d();
            }
        }
    });
    public static final TileDataParameter<Integer> AMOUNT = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileDetector>(){

        @Override
        public Integer getValue(TileDetector tile) {
            return tile.amount;
        }
    }, new ITileDataConsumer<Integer, TileDetector>(){

        @Override
        public void setValue(TileDetector tile, Integer value) {
            tile.amount = value;
            tile.func_70296_d();
        }
    }, parameter -> {
        GuiScreen gui;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && (gui = Minecraft.func_71410_x().field_71462_r) instanceof GuiDetector) {
            GuiDetector cfr_ignored_0 = (GuiDetector)gui;
            GuiDetector.AMOUNT.func_146180_a(String.valueOf(parameter.getValue()));
        }
    });
    private static final int SPEED = 5;
    public static final int MODE_UNDER = 0;
    public static final int MODE_EQUAL = 1;
    public static final int MODE_ABOVE = 2;
    public static final int MODE_AUTOCRAFTING = 3;
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_AMOUNT = "Amount";
    private static final String NBT_POWERED = "Powered";
    private static final String NBT_TYPE = "Type";
    private ItemHandlerBasic itemFilters = new ItemHandlerBasic(1, this, new IItemValidator[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(1, this);
    private int compare = 0;
    private int type = 0;
    private int mode = 1;
    private int amount = 0;
    private boolean powered = false;
    private boolean wasPowered;

    public TileDetector() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(AMOUNT);
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.config.detectorUsage;
    }

    @Override
    public void updateNode() {
        if (this.ticks % 5 == 0) {
            if (this.type == 0) {
                ItemStack slot = this.itemFilters.getStackInSlot(0);
                if (slot != null) {
                    if (this.mode == 3) {
                        boolean found = false;
                        for (ICraftingTask task : this.network.getCraftingTasks()) {
                            for (ItemStack output : task.getPattern().getOutputs()) {
                                if (!CompareUtils.compareStackNoQuantity(slot, output)) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            break;
                        }
                        this.powered = found;
                    } else {
                        ItemStack stack = this.network.getItemStorage().get(slot, this.compare);
                        this.powered = this.isPowered(stack == null ? null : Integer.valueOf(stack.field_77994_a));
                    }
                } else {
                    this.powered = this.mode == 3 && !this.network.getCraftingTasks().isEmpty();
                }
            } else if (this.type == 1) {
                FluidStack stack;
                FluidStack slot = this.fluidFilters.getFluidStackInSlot(0);
                this.powered = slot != null ? this.isPowered((stack = this.network.getFluidStorage().get(slot, this.compare)) == null ? null : Integer.valueOf(stack.amount)) : false;
            }
        }
    }

    @Override
    public void func_73660_a() {
        if (this.powered != this.wasPowered) {
            this.wasPowered = this.powered;
            this.field_145850_b.func_175685_c(this.field_174879_c, (Block)RefinedStorageBlocks.DETECTOR);
            this.updateBlock();
        }
        super.func_73660_a();
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        super.onConnectionChange(network, state);
        if (!state) {
            this.powered = false;
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean isPowered(Integer size) {
        if (size != null) {
            switch (this.mode) {
                case 0: {
                    return size < this.amount;
                }
                case 1: {
                    return size == this.amount;
                }
                case 2: {
                    return size > this.amount;
                }
            }
        } else {
            if (this.mode == 0 && this.amount != 0) {
                return true;
            }
            return this.mode == 1 && this.amount == 0;
        }
        return false;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_AMOUNT)) {
            this.amount = tag.func_74762_e(NBT_AMOUNT);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        TileDetector.readItems((IItemHandler)this.itemFilters, 0, tag);
        TileDetector.readItems((IItemHandler)this.fluidFilters, 1, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_AMOUNT, this.amount);
        tag.func_74768_a(NBT_TYPE, this.type);
        TileDetector.writeItems((IItemHandler)this.itemFilters, 0, tag);
        TileDetector.writeItems((IItemHandler)this.fluidFilters, 1, tag);
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        this.powered = tag.func_74767_n(NBT_POWERED);
        super.readUpdate(tag);
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74757_a(NBT_POWERED, this.powered);
        return tag;
    }

    public IItemHandler getInventory() {
        return this.itemFilters;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
    }

    @Override
    public int getType() {
        return this.field_145850_b.field_72995_K ? TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.func_70296_d();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }
}

