/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.RefinedStorage;
import refinedstorage.RefinedStorageItems;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.storage.fluid.IFluidStorage;
import refinedstorage.api.storage.fluid.IFluidStorageProvider;
import refinedstorage.api.storage.item.IItemStorage;
import refinedstorage.api.storage.item.IItemStorageProvider;
import refinedstorage.apiimpl.storage.NBTStorage;
import refinedstorage.apiimpl.storage.fluid.FluidStorageNBT;
import refinedstorage.apiimpl.storage.fluid.FluidUtils;
import refinedstorage.apiimpl.storage.item.ItemStorageNBT;
import refinedstorage.block.EnumFluidStorageType;
import refinedstorage.block.EnumItemStorageType;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerFluid;
import refinedstorage.tile.IStorageGui;
import refinedstorage.tile.TileNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.config.IPrioritizable;
import refinedstorage.tile.config.IType;
import refinedstorage.tile.data.TileDataParameter;

public class TileDiskDrive
extends TileNode
implements IItemStorageProvider,
IFluidStorageProvider,
IStorageGui,
IComparable,
IFilterable,
IPrioritizable,
IType {
    public static final TileDataParameter<Integer> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer> TYPE = IType.createParameter();
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_STORED = "Stored";
    private static final String NBT_TYPE = "Type";
    private ItemHandlerBasic disks = new ItemHandlerBasic(8, this, new IItemValidator[]{IItemValidator.STORAGE_DISK}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                NBTStorage.constructFromDrive(this.getStackInSlot(slot), slot, TileDiskDrive.this.itemStorages, TileDiskDrive.this.fluidStorages, s -> new ItemStorage((ItemStack)s), s -> new FluidStorage((ItemStack)s));
                if (TileDiskDrive.this.network != null) {
                    TileDiskDrive.this.network.getItemStorage().rebuild();
                    TileDiskDrive.this.network.getFluidStorage().rebuild();
                }
            }
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (TileDiskDrive.this.itemStorages[slot] != null) {
                TileDiskDrive.this.itemStorages[slot].writeToNBT();
            }
            if (TileDiskDrive.this.fluidStorages[slot] != null) {
                TileDiskDrive.this.fluidStorages[slot].writeToNBT();
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private ItemHandlerBasic itemFilters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, this);
    private ItemStorage[] itemStorages = new ItemStorage[8];
    private FluidStorage[] fluidStorages = new FluidStorage[8];
    private int priority = 0;
    private int compare = 0;
    private int mode = 0;
    private int type = 0;
    private int stored = 0;

    public TileDiskDrive() {
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(TYPE);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.stored != this.getStoredForDisplay()) {
            this.stored = this.getStoredForDisplay();
            this.updateBlock();
        }
        super.func_73660_a();
    }

    @Override
    public int getEnergyUsage() {
        int usage = RefinedStorage.INSTANCE.config.diskDriveUsage;
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            if (this.disks.getStackInSlot(i) == null) continue;
            usage += RefinedStorage.INSTANCE.config.diskDrivePerDiskUsage;
        }
        return usage;
    }

    @Override
    public void updateNode() {
    }

    public void onBreak() {
        for (ItemStorage itemStorage : this.itemStorages) {
            if (itemStorage == null) continue;
            itemStorage.writeToNBT();
        }
        for (FluidStorage fluidStorage : this.fluidStorages) {
            if (fluidStorage == null) continue;
            fluidStorage.writeToNBT();
        }
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        super.onConnectionChange(network, state);
        network.getItemStorage().rebuild();
        network.getFluidStorage().rebuild();
    }

    @Override
    public void addItemStorages(List<IItemStorage> storages) {
        for (ItemStorage storage : this.itemStorages) {
            if (storage == null) continue;
            storages.add(storage);
        }
    }

    @Override
    public void addFluidStorages(List<IFluidStorage> storages) {
        for (FluidStorage storage : this.fluidStorages) {
            if (storage == null) continue;
            storages.add(storage);
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileDiskDrive.readItems((IItemHandler)this.disks, 0, tag);
        TileDiskDrive.readItems((IItemHandler)this.itemFilters, 1, tag);
        TileDiskDrive.readItems((IItemHandler)this.fluidFilters, 2, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            if (this.itemStorages[i] != null) {
                this.itemStorages[i].writeToNBT();
            }
            if (this.fluidStorages[i] == null) continue;
            this.fluidStorages[i].writeToNBT();
        }
        TileDiskDrive.writeItems((IItemHandler)this.disks, 0, tag);
        TileDiskDrive.writeItems((IItemHandler)this.itemFilters, 1, tag);
        TileDiskDrive.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        return tag;
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74768_a(NBT_STORED, this.stored);
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        this.stored = tag.func_74762_e(NBT_STORED);
        super.readUpdate(tag);
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    public int getStoredForDisplay() {
        if (!this.field_145850_b.field_72995_K) {
            float stored = 0.0f;
            float capacity = 0.0f;
            for (int i = 0; i < this.disks.getSlots(); ++i) {
                int diskCapacity;
                ItemStack disk = this.disks.getStackInSlot(i);
                if (disk == null) continue;
                int n = diskCapacity = disk.func_77973_b() == RefinedStorageItems.STORAGE_DISK ? EnumItemStorageType.getById(disk.func_77952_i()).getCapacity() : EnumFluidStorageType.getById(disk.func_77952_i()).getCapacity();
                if (diskCapacity == -1) {
                    return 0;
                }
                stored += disk.func_77973_b() == RefinedStorageItems.STORAGE_DISK ? (float)ItemStorageNBT.getStoredFromNBT(disk.func_77978_p()) : (float)FluidStorageNBT.getStoredFromNBT(disk.func_77978_p());
                capacity += (float)diskCapacity;
            }
            if (capacity == 0.0f) {
                return 0;
            }
            return (int)Math.floor(stored / capacity * 7.0f);
        }
        return this.stored;
    }

    @Override
    public String getGuiTitle() {
        return "block.refinedstorage:disk_drive.name";
    }

    @Override
    public TileDataParameter<Integer> getTypeParameter() {
        return TYPE;
    }

    @Override
    public TileDataParameter<Integer> getRedstoneModeParameter() {
        return REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer> getCompareParameter() {
        return COMPARE;
    }

    @Override
    public TileDataParameter<Integer> getFilterParameter() {
        return MODE;
    }

    @Override
    public TileDataParameter<Integer> getPriorityParameter() {
        return PRIORITY;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.func_70296_d();
    }

    @Override
    public int getStored() {
        int stored = 0;
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            ItemStack disk = this.disks.getStackInSlot(i);
            if (disk == null) continue;
            stored += disk.func_77973_b() == RefinedStorageItems.STORAGE_DISK ? ItemStorageNBT.getStoredFromNBT(disk.func_77978_p()) : FluidStorageNBT.getStoredFromNBT(disk.func_77978_p());
        }
        return stored;
    }

    @Override
    public int getCapacity() {
        int capacity = 0;
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            int diskCapacity;
            ItemStack disk = this.disks.getStackInSlot(i);
            if (disk == null) continue;
            int n = diskCapacity = disk.func_77973_b() == RefinedStorageItems.STORAGE_DISK ? EnumItemStorageType.getById(disk.func_77952_i()).getCapacity() : EnumFluidStorageType.getById(disk.func_77952_i()).getCapacity();
            if (diskCapacity == -1) {
                return -1;
            }
            capacity += diskCapacity;
        }
        return capacity;
    }

    public IItemHandler getDisks() {
        return this.disks;
    }

    @Override
    public int getType() {
        return this.field_145850_b.field_72995_K ? TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.func_70296_d();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    @Override
    public IItemHandler getDrops() {
        return this.disks;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.disks);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public class FluidStorage
    extends FluidStorageNBT {
        public FluidStorage(ItemStack disk) {
            super(disk.func_77978_p(), EnumFluidStorageType.getById(disk.func_77952_i()).getCapacity(), TileDiskDrive.this);
        }

        @Override
        public int getPriority() {
            return TileDiskDrive.this.priority;
        }

        @Override
        public FluidStack insertFluid(FluidStack stack, int size, boolean simulate) {
            if (!IFilterable.canTakeFluids(TileDiskDrive.this.fluidFilters, TileDiskDrive.this.mode, TileDiskDrive.this.getCompare(), stack)) {
                return FluidUtils.copyStackWithSize(stack, size);
            }
            return super.insertFluid(stack, size, simulate);
        }
    }

    public class ItemStorage
    extends ItemStorageNBT {
        public ItemStorage(ItemStack disk) {
            super(disk.func_77978_p(), EnumItemStorageType.getById(disk.func_77952_i()).getCapacity(), TileDiskDrive.this);
        }

        @Override
        public int getPriority() {
            return TileDiskDrive.this.priority;
        }

        @Override
        public ItemStack insertItem(ItemStack stack, int size, boolean simulate) {
            if (!IFilterable.canTake((IItemHandler)TileDiskDrive.this.itemFilters, TileDiskDrive.this.mode, TileDiskDrive.this.getCompare(), stack)) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            return super.insertItem(stack, size, simulate);
        }
    }
}

