/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.RefinedStorage;
import refinedstorage.apiimpl.storage.NBTStorage;
import refinedstorage.apiimpl.storage.fluid.FluidStorageNBT;
import refinedstorage.apiimpl.storage.fluid.FluidUtils;
import refinedstorage.apiimpl.storage.item.ItemStorageNBT;
import refinedstorage.block.EnumFluidStorageType;
import refinedstorage.block.EnumItemStorageType;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerFluid;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.tile.TileNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.config.IType;
import refinedstorage.tile.data.ITileDataConsumer;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.TileDataParameter;

public class TileDiskManipulator
extends TileNode
implements IComparable,
IFilterable,
IType {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer> TYPE = IType.createParameter();
    public static final int IO_MODE_INSERT = 0;
    public static final int IO_MODE_EXTRACT = 1;
    public static final TileDataParameter<Integer> IO_MODE = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileDiskManipulator>(){

        @Override
        public Integer getValue(TileDiskManipulator tile) {
            return tile.ioMode;
        }
    }, new ITileDataConsumer<Integer, TileDiskManipulator>(){

        @Override
        public void setValue(TileDiskManipulator tile, Integer value) {
            tile.ioMode = value;
            tile.func_70296_d();
        }
    });
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_IO_MODE = "IOMode";
    private int compare = 0;
    private int mode = 0;
    private int type = 0;
    private int ioMode = 0;
    private ItemStorage[] itemStorages = new ItemStorage[6];
    private FluidStorage[] fluidStorages = new FluidStorage[6];
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2, 4);
    private ItemHandlerBasic disks = new ItemHandlerBasic(12, this, new IItemValidator[]{IItemValidator.STORAGE_DISK}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && slot < 6) {
                NBTStorage.constructFromDrive(this.getStackInSlot(slot), slot, TileDiskManipulator.this.itemStorages, TileDiskManipulator.this.fluidStorages, s -> new ItemStorage((ItemStack)s), s -> new FluidStorage((ItemStack)s));
            }
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < 6) {
                if (TileDiskManipulator.this.itemStorages[slot] != null) {
                    TileDiskManipulator.this.itemStorages[slot].writeToNBT();
                }
                if (TileDiskManipulator.this.fluidStorages[slot] != null) {
                    TileDiskManipulator.this.fluidStorages[slot].writeToNBT();
                }
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private ItemHandlerBasic itemFilters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, this);

    public TileDiskManipulator() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(IO_MODE);
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.config.diskManipulatorUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        int slot;
        if (this.ticks % this.upgrades.getSpeed() != 0) {
            return;
        }
        if (this.type == 0) {
            for (slot = 0; slot < this.itemStorages.length && this.itemStorages[slot] == null; ++slot) {
            }
            if (slot == this.itemStorages.length) {
                return;
            }
            ItemStorage storage = this.itemStorages[slot];
            if (this.ioMode == 0) {
                this.insertIntoNetwork(storage, slot);
            } else if (this.ioMode == 1) {
                this.extractFromNetwork(storage, slot);
            }
        } else if (this.type == 1) {
            while (slot < this.fluidStorages.length && this.fluidStorages[slot] == null) {
                ++slot;
            }
            if (slot == this.fluidStorages.length) {
                return;
            }
            FluidStorage storage = this.fluidStorages[slot];
            if (this.ioMode == 0) {
                this.insertIntoNetwork(storage, slot);
            } else if (this.ioMode == 1) {
                this.extractFromNetwork(storage, slot);
            }
        }
    }

    private int getInteractStackSize() {
        return this.upgrades.hasUpgrade(4) ? 64 : 1;
    }

    private void insertIntoNetwork(ItemStorage storage, int slot) {
        if (storage.getStored() == 0) {
            this.moveDriveToOutput(slot);
            return;
        }
        ItemStack extracted = null;
        int i = 0;
        do {
            ItemStack stack = null;
            while (storage.getItems().size() > i && stack == null) {
                stack = storage.getItems().get(i++);
            }
            if (stack == null) continue;
            extracted = storage.extractItem(stack, this.getInteractStackSize(), this.compare);
        } while (storage.getItems().size() > i && extracted == null);
        if (extracted == null) {
            this.moveDriveToOutput(slot);
            return;
        }
        ItemStack remainder = this.network.insertItem(extracted, extracted.field_77994_a, false);
        if (remainder != null) {
            storage.insertItem(remainder, remainder.field_77994_a, false);
        }
    }

    private void extractFromNetwork(ItemStorage storage, int slot) {
        if (storage.getStored() == storage.getCapacity()) {
            this.moveDriveToOutput(slot);
            return;
        }
        ItemStack extracted = null;
        int i = 0;
        if (IFilterable.isEmpty((IItemHandler)this.itemFilters)) {
            ItemStack toExtract = null;
            ArrayList<ItemStack> networkItems = new ArrayList<ItemStack>(this.network.getItemStorage().getStacks());
            int j = 0;
            while ((toExtract == null || toExtract.field_77994_a == 0) && j < networkItems.size()) {
                toExtract = networkItems.get(j++);
            }
            if (toExtract != null) {
                extracted = this.network.extractItem(toExtract, this.getInteractStackSize(), this.compare);
            }
        } else {
            while (this.itemFilters.getSlots() > i && extracted == null) {
                ItemStack stack = null;
                while (this.itemFilters.getSlots() > i && stack == null) {
                    stack = this.itemFilters.getStackInSlot(i++);
                }
                if (stack == null) continue;
                extracted = this.network.extractItem(stack, this.getInteractStackSize(), this.compare);
            }
        }
        if (extracted == null) {
            this.moveDriveToOutput(slot);
            return;
        }
        ItemStack remainder = storage.insertItem(extracted, extracted.field_77994_a, false);
        if (remainder != null) {
            this.network.insertItem(remainder, remainder.field_77994_a, false);
        }
    }

    private void insertIntoNetwork(FluidStorage storage, int slot) {
        if (storage.getStored() == 0) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack extracted = null;
        int i = 0;
        do {
            FluidStack stack = storage.getStacks().get(i);
            while (stack == null && storage.getStacks().size() > i) {
                ++i;
            }
            if (stack == null) continue;
            extracted = storage.extractFluid(stack, this.getInteractStackSize(), this.compare);
        } while (extracted == null && storage.getStacks().size() > i);
        if (extracted == null) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack remainder = this.network.insertFluid(extracted, extracted.amount, false);
        if (remainder != null) {
            storage.insertFluid(remainder, remainder.amount, false);
        }
    }

    private void extractFromNetwork(FluidStorage storage, int slot) {
        if (storage.getStored() == storage.getCapacity()) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack extracted = null;
        int i = 0;
        if (IFilterable.isEmpty((IItemHandler)this.itemFilters)) {
            FluidStack toExtract = null;
            ArrayList<FluidStack> networkFluids = new ArrayList<FluidStack>(this.network.getFluidStorage().getStacks());
            int j = 0;
            while ((toExtract == null || toExtract.amount == 0) && j < networkFluids.size()) {
                toExtract = networkFluids.get(j++);
            }
            if (toExtract != null) {
                extracted = this.network.extractFluid(toExtract, this.getInteractStackSize(), this.compare);
            }
        } else {
            while (this.fluidFilters.getSlots() > i && extracted == null) {
                FluidStack stack = null;
                while (this.fluidFilters.getSlots() > i && stack == null) {
                    stack = this.fluidFilters.getFluidStackInSlot(i++);
                }
                if (stack == null) continue;
                extracted = this.network.extractFluid(stack, this.getInteractStackSize(), this.compare);
            }
        }
        if (extracted == null) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack remainder = storage.insertFluid(extracted, extracted.amount, false);
        if (remainder != null) {
            this.network.insertFluid(remainder, remainder.amount, false);
        }
    }

    private void moveDriveToOutput(int slot) {
        ItemStack disk = this.disks.getStackInSlot(slot);
        if (disk != null) {
            int i;
            for (i = 6; this.disks.getStackInSlot(i) != null && i < 12; ++i) {
            }
            if (i == 12) {
                return;
            }
            if (slot < 6) {
                if (this.itemStorages[slot] != null) {
                    this.itemStorages[slot].writeToNBT();
                    this.itemStorages[slot] = null;
                }
                if (this.fluidStorages[slot] != null) {
                    this.fluidStorages[slot].writeToNBT();
                    this.fluidStorages[slot] = null;
                }
            }
            this.disks.extractItem(slot, 1, false);
            this.disks.insertItem(i, disk, false);
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    public IItemHandler getDisks() {
        return this.disks;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileDiskManipulator.readItems((IItemHandler)this.disks, 0, tag);
        TileDiskManipulator.readItems((IItemHandler)this.itemFilters, 1, tag);
        TileDiskManipulator.readItems((IItemHandler)this.fluidFilters, 2, tag);
        TileDiskManipulator.readItems((IItemHandler)this.upgrades, 3, tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_IO_MODE)) {
            this.ioMode = tag.func_74762_e(NBT_IO_MODE);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        TileDiskManipulator.writeItems((IItemHandler)this.disks, 0, tag);
        TileDiskManipulator.writeItems((IItemHandler)this.itemFilters, 1, tag);
        TileDiskManipulator.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        TileDiskManipulator.writeItems((IItemHandler)this.upgrades, 3, tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74768_a(NBT_IO_MODE, this.ioMode);
        return tag;
    }

    @Override
    public IItemHandler getDrops() {
        return this.disks;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.disks);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public void onBreak() {
        for (ItemStorage itemStorage : this.itemStorages) {
            if (itemStorage == null) continue;
            itemStorage.writeToNBT();
        }
        for (FluidStorage fluidStorage : this.fluidStorages) {
            if (fluidStorage == null) continue;
            fluidStorage.writeToNBT();
        }
    }

    public class FluidStorage
    extends FluidStorageNBT {
        public FluidStorage(ItemStack disk) {
            super(disk.func_77978_p(), EnumFluidStorageType.getById(disk.func_77952_i()).getCapacity(), TileDiskManipulator.this);
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public FluidStack insertFluid(FluidStack stack, int size, boolean simulate) {
            if (!IFilterable.canTakeFluids(TileDiskManipulator.this.fluidFilters, TileDiskManipulator.this.mode, TileDiskManipulator.this.getCompare(), stack)) {
                return FluidUtils.copyStackWithSize(stack, size);
            }
            return super.insertFluid(stack, size, simulate);
        }

        @Override
        public FluidStack extractFluid(FluidStack stack, int size, int flags) {
            if (!IFilterable.canTakeFluids(TileDiskManipulator.this.fluidFilters, TileDiskManipulator.this.mode, TileDiskManipulator.this.getCompare(), stack)) {
                return null;
            }
            return super.extractFluid(stack, size, flags);
        }
    }

    public class ItemStorage
    extends ItemStorageNBT {
        public ItemStorage(ItemStack disk) {
            super(disk.func_77978_p(), EnumItemStorageType.getById(disk.func_77952_i()).getCapacity(), TileDiskManipulator.this);
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public ItemStack insertItem(ItemStack stack, int size, boolean simulate) {
            if (!IFilterable.canTake((IItemHandler)TileDiskManipulator.this.itemFilters, TileDiskManipulator.this.mode, TileDiskManipulator.this.getCompare(), stack)) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            return super.insertItem(stack, size, simulate);
        }

        @Override
        public ItemStack extractItem(ItemStack stack, int size, int flags) {
            if (!IFilterable.canTake((IItemHandler)TileDiskManipulator.this.itemFilters, TileDiskManipulator.this.mode, TileDiskManipulator.this.getCompare(), stack)) {
                return null;
            }
            return super.extractItem(stack, size, flags);
        }
    }
}

