/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import mcmultipart.microblock.IMicroblock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.RefinedStorage;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerFluid;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.tile.TileMultipartNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.IType;
import refinedstorage.tile.data.TileDataParameter;

public class TileExporter
extends TileMultipartNode
implements IComparable,
IType {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> TYPE = IType.createParameter();
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private ItemHandlerBasic itemFilters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, this);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2, 3, 4);
    private int compare = 0;
    private int type = 0;

    public TileExporter() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(TYPE);
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return !TileExporter.isBlockingMicroblock(microblock, this.getDirection());
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.config.exporterUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        block4: {
            IFluidHandler handler;
            block5: {
                int size;
                if (this.ticks % this.upgrades.getSpeed() != 0) break block4;
                if (this.type != 0) break block5;
                IItemHandler handler2 = TileExporter.getItemHandler(this.getFacingTile(), this.getDirection().func_176734_d());
                int n = size = this.upgrades.hasUpgrade(4) ? 64 : 1;
                if (handler2 == null) break block4;
                for (int i = 0; i < this.itemFilters.getSlots(); ++i) {
                    ItemStack slot = this.itemFilters.getStackInSlot(i);
                    if (slot == null) continue;
                    ItemStack took = this.network.extractItem(slot, size, this.compare);
                    if (took != null) {
                        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)handler2, (ItemStack)took, (boolean)false);
                        if (remainder == null) continue;
                        this.network.insertItem(remainder, remainder.field_77994_a, false);
                        continue;
                    }
                    if (!this.upgrades.hasUpgrade(3)) continue;
                    NetworkUtils.scheduleCraftingTaskIfUnscheduled(this.network, slot, 1, this.compare);
                }
                break block4;
            }
            if (this.type == 1 && (handler = this.getFluidHandler(this.getFacingTile(), this.getDirection().func_176734_d())) != null) {
                for (FluidStack stack : this.fluidFilters.getFluids()) {
                    int remainder;
                    int toExtract;
                    FluidStack took;
                    FluidStack stackInStorage;
                    if (stack == null || (stackInStorage = this.network.getFluidStorage().get(stack, this.compare)) == null || (took = this.network.extractFluid(stack, toExtract = Math.min(1000, stackInStorage.amount), this.compare)) == null || (remainder = toExtract - handler.fill(took, true)) <= 0) continue;
                    this.network.insertFluid(took, remainder, false);
                }
            }
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        TileExporter.readItems((IItemHandler)this.itemFilters, 0, tag);
        TileExporter.readItems((IItemHandler)this.upgrades, 1, tag);
        TileExporter.readItems((IItemHandler)this.fluidFilters, 2, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        TileExporter.writeItems((IItemHandler)this.itemFilters, 0, tag);
        TileExporter.writeItems((IItemHandler)this.upgrades, 1, tag);
        TileExporter.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        return tag;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public int getType() {
        return this.field_145850_b.field_72995_K ? TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.func_70296_d();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.upgrades);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

