/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.RefinedStorage;
import refinedstorage.apiimpl.storage.fluid.FluidUtils;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerFluid;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.tile.TileNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.RefinedStorageSerializers;
import refinedstorage.tile.data.TileDataParameter;

public class TileFluidInterface
extends TileNode
implements IComparable {
    public static final int TANK_CAPACITY = 16000;
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<FluidStack> TANK_IN = new TileDataParameter<FluidStack>(RefinedStorageSerializers.FLUID_STACK_SERIALIZER, null, new ITileDataProducer<FluidStack, TileFluidInterface>(){

        @Override
        public FluidStack getValue(TileFluidInterface tile) {
            return tile.tankIn.getFluid();
        }
    });
    public static final TileDataParameter<FluidStack> TANK_OUT = new TileDataParameter<FluidStack>(RefinedStorageSerializers.FLUID_STACK_SERIALIZER, null, new ITileDataProducer<FluidStack, TileFluidInterface>(){

        @Override
        public FluidStack getValue(TileFluidInterface tile) {
            return tile.tankOut.getFluid();
        }
    });
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TANK_IN = "TankIn";
    private static final String NBT_TANK_OUT = "TankOut";
    private int compare = 0;
    private FluidTank tankIn = new FluidTank(16000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            if (TileFluidInterface.this.field_145850_b != null && !((TileFluidInterface)TileFluidInterface.this).field_145850_b.field_72995_K) {
                TileFluidInterface.this.dataManager.sendParameterToWatchers(TANK_IN);
            }
            TileFluidInterface.this.func_70296_d();
        }
    };
    private FluidTank tankOut = new FluidTank(16000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            if (TileFluidInterface.this.field_145850_b != null && !((TileFluidInterface)TileFluidInterface.this).field_145850_b.field_72995_K) {
                TileFluidInterface.this.dataManager.sendParameterToWatchers(TANK_OUT);
            }
            TileFluidInterface.this.func_70296_d();
        }
    };
    private ItemHandlerBasic in = new ItemHandlerBasic(1, this, new IItemValidator[0]);
    private ItemHandlerFluid out = new ItemHandlerFluid(1, this);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2);

    public TileFluidInterface() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addParameter(TANK_IN);
        this.dataManager.addParameter(TANK_OUT);
        this.tankIn.setCanDrain(false);
        this.tankIn.setCanFill(true);
        this.tankOut.setCanDrain(true);
        this.tankOut.setCanFill(false);
    }

    @Override
    public void updateNode() {
        FluidStack fluid;
        ItemStack container = this.in.getStackInSlot(0);
        if (container != null && (fluid = FluidUtils.getFluidFromStack(container, true)) != null && this.tankIn.fillInternal(fluid, false) == fluid.amount) {
            this.tankIn.fillInternal(FluidUtils.getFluidFromStack(container, false), true);
        }
        if (this.ticks % this.upgrades.getSpeed() == 0) {
            int remainder;
            int toExtract;
            FluidStack took;
            FluidStack stackInStorage;
            FluidStack remainder2;
            FluidStack drained = this.tankIn.drainInternal(1000, true);
            if (drained != null && (remainder2 = this.network.insertFluid(drained, drained.amount, false)) != null) {
                this.tankIn.fillInternal(remainder2, true);
            }
            FluidStack stack = this.out.getFluidStackInSlot(0);
            if (this.tankOut.getFluid() != null && (stack == null || this.tankOut.getFluid().getFluid() != stack.getFluid())) {
                FluidStack remainder3 = this.tankOut.drainInternal(1000, true);
                if (remainder3 != null) {
                    this.network.insertFluid(remainder3, remainder3.amount, false);
                }
            } else if (stack != null && (stackInStorage = this.network.getFluidStorage().get(stack, this.compare)) != null && (took = this.network.extractFluid(stack, toExtract = Math.min(1000, stackInStorage.amount), this.compare)) != null && (remainder = toExtract - this.tankOut.fillInternal(took, true)) > 0) {
                this.network.insertFluid(took, remainder, false);
            }
        }
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.config.fluidInterfaceUsage;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        TileFluidInterface.writeItems((IItemHandler)this.upgrades, 0, tag);
        TileFluidInterface.writeItems((IItemHandler)this.in, 1, tag);
        TileFluidInterface.writeItems((IItemHandler)this.out, 2, tag);
        tag.func_74782_a(NBT_TANK_IN, (NBTBase)this.tankIn.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a(NBT_TANK_OUT, (NBTBase)this.tankOut.writeToNBT(new NBTTagCompound()));
        tag.func_74768_a(NBT_COMPARE, this.compare);
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileFluidInterface.readItems((IItemHandler)this.upgrades, 0, tag);
        TileFluidInterface.readItems((IItemHandler)this.in, 1, tag);
        TileFluidInterface.readItems((IItemHandler)this.out, 2, tag);
        if (tag.func_74764_b(NBT_TANK_IN)) {
            this.tankIn.readFromNBT(tag.func_74775_l(NBT_TANK_IN));
        }
        if (tag.func_74764_b(NBT_TANK_OUT)) {
            this.tankOut.readFromNBT(tag.func_74775_l(NBT_TANK_OUT));
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
    }

    public ItemHandlerUpgrade getUpgrades() {
        return this.upgrades;
    }

    public ItemHandlerBasic getIn() {
        return this.in;
    }

    public ItemHandlerFluid getOut() {
        return this.out;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)(facing == EnumFacing.DOWN ? this.tankOut : this.tankIn);
        }
        return (T)super.getCapability(capability, facing);
    }
}

