/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.RefinedStorage;
import refinedstorage.RefinedStorageBlocks;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.storage.fluid.IFluidStorage;
import refinedstorage.api.storage.fluid.IFluidStorageProvider;
import refinedstorage.apiimpl.storage.fluid.FluidStorageNBT;
import refinedstorage.apiimpl.storage.fluid.FluidUtils;
import refinedstorage.block.BlockFluidStorage;
import refinedstorage.block.EnumFluidStorageType;
import refinedstorage.inventory.ItemHandlerFluid;
import refinedstorage.tile.IStorageGui;
import refinedstorage.tile.TileNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.config.IPrioritizable;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.TileDataParameter;

public class TileFluidStorage
extends TileNode
implements IFluidStorageProvider,
IStorageGui,
IComparable,
IFilterable,
IPrioritizable {
    public static final TileDataParameter<Integer> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer> STORED = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileFluidStorage>(){

        @Override
        public Integer getValue(TileFluidStorage tile) {
            return FluidStorageNBT.getStoredFromNBT(tile.storageTag);
        }
    });
    public static final String NBT_STORAGE = "Storage";
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private ItemHandlerFluid filters = new ItemHandlerFluid(9, this);
    private NBTTagCompound storageTag = FluidStorageNBT.createNBT();
    private FluidStorage storage;
    private EnumFluidStorageType type;
    private int priority = 0;
    private int compare = 0;
    private int mode = 0;

    public TileFluidStorage() {
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(STORED);
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.config.fluidStorageUsage;
    }

    @Override
    public void updateNode() {
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.storage == null && this.storageTag != null) {
            this.storage = new FluidStorage();
            if (this.network != null) {
                this.network.getFluidStorage().rebuild();
            }
        }
    }

    public void onBreak() {
        if (this.storage != null) {
            this.storage.writeToNBT();
        }
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        super.onConnectionChange(network, state);
        network.getFluidStorage().rebuild();
    }

    @Override
    public void addFluidStorages(List<IFluidStorage> storages) {
        if (this.storage != null) {
            storages.add(this.storage);
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileFluidStorage.readItems((IItemHandler)this.filters, 0, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_STORAGE)) {
            this.storageTag = tag.func_74775_l(NBT_STORAGE);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        TileFluidStorage.writeItems((IItemHandler)this.filters, 0, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        if (this.storage != null) {
            this.storage.writeToNBT();
        }
        tag.func_74782_a(NBT_STORAGE, (NBTBase)this.storageTag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        return tag;
    }

    public EnumFluidStorageType getType() {
        if (this.type == null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == RefinedStorageBlocks.FLUID_STORAGE) {
            this.type = (EnumFluidStorageType)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFluidStorage.TYPE));
        }
        return this.type == null ? EnumFluidStorageType.TYPE_64K : this.type;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    @Override
    public String getGuiTitle() {
        return "block.refinedstorage:fluid_storage." + this.getType().getId() + ".name";
    }

    @Override
    public TileDataParameter<Integer> getTypeParameter() {
        return null;
    }

    @Override
    public TileDataParameter<Integer> getRedstoneModeParameter() {
        return REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer> getCompareParameter() {
        return COMPARE;
    }

    @Override
    public TileDataParameter<Integer> getFilterParameter() {
        return MODE;
    }

    @Override
    public TileDataParameter<Integer> getPriorityParameter() {
        return PRIORITY;
    }

    public NBTTagCompound getStorageTag() {
        return this.storageTag;
    }

    public void setStorageTag(NBTTagCompound storageTag) {
        this.storageTag = storageTag;
    }

    public FluidStorageNBT getStorage() {
        return this.storage;
    }

    public ItemHandlerFluid getFilters() {
        return this.filters;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.func_70296_d();
    }

    @Override
    public int getStored() {
        return STORED.getValue();
    }

    @Override
    public int getCapacity() {
        return this.getType().getCapacity();
    }

    class FluidStorage
    extends FluidStorageNBT {
        public FluidStorage() {
            super(TileFluidStorage.this.getStorageTag(), TileFluidStorage.this.getCapacity(), TileFluidStorage.this);
        }

        @Override
        public int getPriority() {
            return TileFluidStorage.this.priority;
        }

        @Override
        public FluidStack insertFluid(FluidStack stack, int size, boolean simulate) {
            if (!IFilterable.canTakeFluids(TileFluidStorage.this.filters, TileFluidStorage.this.mode, TileFluidStorage.this.compare, stack)) {
                return FluidUtils.copyStackWithSize(stack, size);
            }
            return super.insertFluid(stack, size, simulate);
        }
    }
}

