/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import mcmultipart.microblock.IMicroblock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.RefinedStorage;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerFluid;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.tile.TileDiskDrive;
import refinedstorage.tile.TileMultipartNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.config.IType;
import refinedstorage.tile.data.TileDataParameter;

public class TileImporter
extends TileMultipartNode
implements IComparable,
IFilterable,
IType {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer> TYPE = IType.createParameter();
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private ItemHandlerBasic itemFilters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, this);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2, 4);
    private int compare = 0;
    private int mode = 0;
    private int type = 0;
    private int currentSlot;

    public TileImporter() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(TYPE);
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return !TileImporter.isBlockingMicroblock(microblock, this.getDirection());
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.config.importerUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        FluidStack stack;
        IFluidHandler handler;
        if (this.type == 0) {
            IItemHandler handler2 = TileImporter.getItemHandler(this.getFacingTile(), this.getDirection().func_176734_d());
            if (this.getFacingTile() instanceof TileDiskDrive || handler2 == null) {
                return;
            }
            if (this.currentSlot >= handler2.getSlots()) {
                this.currentSlot = 0;
            }
            if (handler2.getSlots() > 0) {
                ItemStack stack2 = handler2.getStackInSlot(this.currentSlot);
                if (stack2 == null || !IFilterable.canTake((IItemHandler)this.itemFilters, this.mode, this.compare, stack2)) {
                    ++this.currentSlot;
                } else if (this.ticks % this.upgrades.getSpeed() == 0) {
                    int quantity = this.upgrades.hasUpgrade(4) ? 64 : 1;
                    ItemStack result = handler2.extractItem(this.currentSlot, quantity, true);
                    if (result != null && this.network.insertItem(result, result.field_77994_a, true) == null) {
                        this.network.insertItem(result, result.field_77994_a, false);
                        handler2.extractItem(this.currentSlot, quantity, false);
                    } else {
                        ++this.currentSlot;
                    }
                }
            }
        } else if (this.type == 1 && this.ticks % this.upgrades.getSpeed() == 0 && (handler = this.getFluidHandler(this.getFacingTile(), this.getDirection().func_176734_d())) != null && (stack = handler.drain(1000, false)) != null && IFilterable.canTakeFluids(this.fluidFilters, this.mode, this.compare, stack) && this.network.insertFluid(stack, stack.amount, true) == null) {
            FluidStack drain = handler.drain(1000, true);
            this.network.insertFluid(drain, drain.amount, false);
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        TileImporter.readItems((IItemHandler)this.itemFilters, 0, tag);
        TileImporter.readItems((IItemHandler)this.upgrades, 1, tag);
        TileImporter.readItems((IItemHandler)this.fluidFilters, 2, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        TileImporter.writeItems((IItemHandler)this.itemFilters, 0, tag);
        TileImporter.writeItems((IItemHandler)this.upgrades, 1, tag);
        TileImporter.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        return tag;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public int getType() {
        return this.field_145850_b.field_72995_K ? TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.func_70296_d();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.upgrades);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

