/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import refinedstorage.RefinedStorage;
import refinedstorage.RefinedStorageItems;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.inventory.ItemValidatorBasic;
import refinedstorage.item.ItemNetworkCard;
import refinedstorage.tile.TileNode;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.TileDataParameter;

public class TileNetworkTransmitter
extends TileNode {
    public static final TileDataParameter<Integer> DISTANCE = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileNetworkTransmitter>(){

        @Override
        public Integer getValue(TileNetworkTransmitter tile) {
            return tile.receiver != null && tile.isSameDimension() ? tile.getDistance() : -1;
        }
    });
    public static final TileDataParameter<Integer> RECEIVER_DIMENSION = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileNetworkTransmitter>(){

        @Override
        public Integer getValue(TileNetworkTransmitter tile) {
            return tile.receiverDimension;
        }
    });
    public static final TileDataParameter<Boolean> RECEIVER_DIMENSION_SUPPORTED = new TileDataParameter<Boolean>(DataSerializers.field_187198_h, false, new ITileDataProducer<Boolean, TileNetworkTransmitter>(){

        @Override
        public Boolean getValue(TileNetworkTransmitter tile) {
            return tile.isDimensionSupported();
        }
    });
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(1, this, new int[]{5}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (TileNetworkTransmitter.this.network != null) {
                NetworkUtils.rebuildGraph(TileNetworkTransmitter.this.network);
            }
        }
    };
    private ItemHandlerBasic networkCard = new ItemHandlerBasic(1, this, new IItemValidator[]{new ItemValidatorBasic(RefinedStorageItems.NETWORK_CARD)}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ItemStack card = this.getStackInSlot(slot);
            if (card == null) {
                TileNetworkTransmitter.this.receiver = null;
            } else {
                TileNetworkTransmitter.this.receiver = ItemNetworkCard.getReceiver(card);
                TileNetworkTransmitter.this.receiverDimension = ItemNetworkCard.getDimension(card);
            }
            if (TileNetworkTransmitter.this.network != null) {
                NetworkUtils.rebuildGraph(TileNetworkTransmitter.this.network);
            }
        }
    };
    private BlockPos receiver;
    private int receiverDimension;

    public TileNetworkTransmitter() {
        this.dataManager.addWatchedParameter(DISTANCE);
        this.dataManager.addWatchedParameter(RECEIVER_DIMENSION);
        this.dataManager.addWatchedParameter(RECEIVER_DIMENSION_SUPPORTED);
        this.rebuildOnUpdateChange = true;
    }

    @Override
    public void updateNode() {
    }

    public boolean canTransmit() {
        return this.canUpdate() && this.receiver != null && this.isDimensionSupported();
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        TileNetworkTransmitter.writeItems((IItemHandler)this.networkCard, 0, tag);
        TileNetworkTransmitter.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileNetworkTransmitter.readItems((IItemHandler)this.networkCard, 0, tag);
        TileNetworkTransmitter.readItems((IItemHandler)this.upgrades, 1, tag);
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.config.networkTransmitterUsage + (this.isSameDimension() ? (int)Math.ceil(RefinedStorage.INSTANCE.config.networkTransmitterPerBlockUsage * (float)this.getDistance()) : 0) + this.upgrades.getEnergyUsage();
    }

    public ItemHandlerBasic getNetworkCard() {
        return this.networkCard;
    }

    public ItemHandlerUpgrade getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.networkCard, this.upgrades});
    }

    public BlockPos getReceiver() {
        return this.receiver;
    }

    public int getReceiverDimension() {
        return this.receiverDimension;
    }

    public int getDistance() {
        if (this.receiver == null) {
            return 0;
        }
        return (int)Math.sqrt(Math.pow(this.field_174879_c.func_177958_n() - this.receiver.func_177958_n(), 2.0) + Math.pow(this.field_174879_c.func_177956_o() - this.receiver.func_177956_o(), 2.0) + Math.pow(this.field_174879_c.func_177952_p() - this.receiver.func_177952_p(), 2.0));
    }

    public boolean isSameDimension() {
        return this.field_145850_b.field_73011_w.getDimension() == this.receiverDimension;
    }

    public boolean isDimensionSupported() {
        return this.isSameDimension() || this.upgrades.hasUpgrade(5);
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }
}

