/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.INetworkNode;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.tile.TileBase;
import refinedstorage.tile.config.IRedstoneConfigurable;
import refinedstorage.tile.config.RedstoneMode;
import refinedstorage.tile.data.TileDataParameter;

public abstract class TileNode
extends TileBase
implements INetworkNode,
IRedstoneConfigurable {
    public static final TileDataParameter<Integer> REDSTONE_MODE = RedstoneMode.createParameter();
    private static final String NBT_CONNECTED = "Connected";
    private static final String NBT_NETWORK = "Network";
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    private boolean active;
    private boolean update;
    private BlockPos networkPos;
    protected boolean connected;
    protected INetworkMaster network;
    protected boolean rebuildOnUpdateChange;

    public TileNode() {
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
    }

    @Override
    public boolean canUpdate() {
        return this.redstoneMode.isEnabled(this.field_145850_b, this.field_174879_c);
    }

    public boolean isActive() {
        return this.isConnected() && this.canUpdate();
    }

    public abstract void updateNode();

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.networkPos != null) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.networkPos);
                if (tile instanceof INetworkMaster) {
                    ((INetworkMaster)tile).getNodeGraph().replace(this);
                    this.onConnected((INetworkMaster)tile);
                }
                this.networkPos = null;
            }
            if (this.update != this.canUpdate() && this.network != null) {
                this.update = this.canUpdate();
                this.onConnectionChange(this.network, this.update);
                if (this.rebuildOnUpdateChange) {
                    NetworkUtils.rebuildGraph(this.network);
                }
            }
            if (this.active != this.isActive() && this.hasConnectivityState()) {
                this.updateBlock();
                this.active = this.isActive();
            }
            if (this.isActive()) {
                this.updateNode();
            }
        }
        super.func_73660_a();
    }

    @Override
    public void onConnected(INetworkMaster network) {
        this.connected = true;
        this.network = network;
        this.onConnectionChange(network, true);
        this.func_70296_d();
    }

    @Override
    public void onDisconnected(INetworkMaster network) {
        this.onConnectionChange(network, false);
        this.connected = false;
        this.network = null;
        this.func_70296_d();
    }

    public void onConnectionChange(INetworkMaster network, boolean state) {
    }

    @Override
    public boolean canConduct(EnumFacing direction) {
        return true;
    }

    @Override
    public INetworkMaster getNetwork() {
        return this.network;
    }

    @Override
    public World getNodeWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        this.redstoneMode = RedstoneMode.read(tag);
        if (tag.func_74764_b(NBT_NETWORK)) {
            this.networkPos = BlockPos.func_177969_a((long)tag.func_74763_f(NBT_NETWORK));
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        this.redstoneMode.write(tag);
        if (this.network != null) {
            tag.func_74772_a(NBT_NETWORK, this.network.getPosition().func_177986_g());
        }
        return tag;
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        if (this.hasConnectivityState()) {
            tag.func_74757_a(NBT_CONNECTED, this.isActive());
        }
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        if (this.hasConnectivityState()) {
            this.connected = tag.func_74767_n(NBT_CONNECTED);
        }
        super.readUpdate(tag);
    }

    public boolean hasConnectivityState() {
        return false;
    }
}

