/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.RefinedStorage;
import refinedstorage.RefinedStorageBlocks;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.storage.item.IItemStorage;
import refinedstorage.api.storage.item.IItemStorageProvider;
import refinedstorage.apiimpl.storage.item.ItemStorageNBT;
import refinedstorage.block.BlockStorage;
import refinedstorage.block.EnumItemStorageType;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.tile.IStorageGui;
import refinedstorage.tile.TileNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.config.IPrioritizable;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.TileDataParameter;

public class TileStorage
extends TileNode
implements IItemStorageProvider,
IStorageGui,
IComparable,
IFilterable,
IPrioritizable {
    public static final TileDataParameter<Integer> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer> STORED = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileStorage>(){

        @Override
        public Integer getValue(TileStorage tile) {
            return ItemStorageNBT.getStoredFromNBT(tile.storageTag);
        }
    });
    public static final String NBT_STORAGE = "Storage";
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private ItemHandlerBasic filters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private NBTTagCompound storageTag = ItemStorageNBT.createNBT();
    private ItemStorage storage;
    private EnumItemStorageType type;
    private int priority = 0;
    private int compare = 0;
    private int mode = 0;

    public TileStorage() {
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(STORED);
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.config.storageUsage;
    }

    @Override
    public void updateNode() {
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.storage == null && this.storageTag != null) {
            this.storage = new ItemStorage();
            if (this.network != null) {
                this.network.getItemStorage().rebuild();
            }
        }
    }

    public void onBreak() {
        if (this.storage != null) {
            this.storage.writeToNBT();
        }
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        super.onConnectionChange(network, state);
        network.getItemStorage().rebuild();
    }

    @Override
    public void addItemStorages(List<IItemStorage> storages) {
        if (this.storage != null) {
            storages.add(this.storage);
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileStorage.readItems((IItemHandler)this.filters, 0, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_STORAGE)) {
            this.storageTag = tag.func_74775_l(NBT_STORAGE);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        TileStorage.writeItems((IItemHandler)this.filters, 0, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        if (this.storage != null) {
            this.storage.writeToNBT();
        }
        tag.func_74782_a(NBT_STORAGE, (NBTBase)this.storageTag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        return tag;
    }

    public EnumItemStorageType getType() {
        if (this.type == null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == RefinedStorageBlocks.STORAGE) {
            this.type = (EnumItemStorageType)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockStorage.TYPE));
        }
        return this.type == null ? EnumItemStorageType.TYPE_1K : this.type;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    @Override
    public String getGuiTitle() {
        return "block.refinedstorage:storage." + this.getType().getId() + ".name";
    }

    @Override
    public TileDataParameter<Integer> getTypeParameter() {
        return null;
    }

    @Override
    public TileDataParameter<Integer> getRedstoneModeParameter() {
        return REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer> getCompareParameter() {
        return COMPARE;
    }

    @Override
    public TileDataParameter<Integer> getFilterParameter() {
        return MODE;
    }

    @Override
    public TileDataParameter<Integer> getPriorityParameter() {
        return PRIORITY;
    }

    public NBTTagCompound getStorageTag() {
        return this.storageTag;
    }

    public void setStorageTag(NBTTagCompound storageTag) {
        this.storageTag = storageTag;
    }

    public ItemStorageNBT getStorage() {
        return this.storage;
    }

    public ItemHandlerBasic getFilters() {
        return this.filters;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.func_70296_d();
    }

    @Override
    public int getStored() {
        return STORED.getValue();
    }

    @Override
    public int getCapacity() {
        return this.getType().getCapacity();
    }

    class ItemStorage
    extends ItemStorageNBT {
        public ItemStorage() {
            super(TileStorage.this.getStorageTag(), TileStorage.this.getCapacity(), TileStorage.this);
        }

        @Override
        public int getPriority() {
            return TileStorage.this.priority;
        }

        @Override
        public ItemStack insertItem(ItemStack stack, int size, boolean simulate) {
            if (!IFilterable.canTake((IItemHandler)TileStorage.this.filters, TileStorage.this.mode, TileStorage.this.compare, stack)) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            return super.insertItem(stack, size, simulate);
        }
    }
}

