/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.RefinedStorage;
import refinedstorage.api.network.IWirelessTransmitter;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.tile.TileNode;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.TileDataParameter;

public class TileWirelessTransmitter
extends TileNode
implements IWirelessTransmitter {
    public static final TileDataParameter<Integer> RANGE = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileWirelessTransmitter>(){

        @Override
        public Integer getValue(TileWirelessTransmitter tile) {
            return tile.getRange();
        }
    });
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 1);

    public TileWirelessTransmitter() {
        this.dataManager.addWatchedParameter(RANGE);
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.config.wirelessTransmitterUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileWirelessTransmitter.readItems((IItemHandler)this.upgrades, 0, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        TileWirelessTransmitter.writeItems((IItemHandler)this.upgrades, 0, tag);
        return tag;
    }

    @Override
    public int getRange() {
        return RefinedStorage.INSTANCE.config.wirelessTransmitterBaseRange + this.upgrades.getUpgradeCount(1) * RefinedStorage.INSTANCE.config.wirelessTransmitterRangePerUpgrade;
    }

    @Override
    public BlockPos getOrigin() {
        return this.field_174879_c;
    }

    public ItemHandlerBasic getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public boolean canConduct(EnumFacing direction) {
        return false;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.upgrades);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

