/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile.data;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import refinedstorage.tile.ClientCraftingTask;
import refinedstorage.tile.ClientNode;

public final class RefinedStorageSerializers {
    public static final DataSerializer<List<ClientNode>> CLIENT_NODE_SERIALIZER = new DataSerializer<List<ClientNode>>(){

        public void write(PacketBuffer buf, List<ClientNode> nodes) {
            buf.writeInt(nodes.size());
            for (ClientNode node : nodes) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)node.getStack());
                buf.writeInt(node.getAmount());
                buf.writeInt(node.getEnergyUsage());
            }
        }

        public List<ClientNode> read(PacketBuffer buf) {
            ArrayList<ClientNode> nodes = new ArrayList<ClientNode>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                nodes.add(new ClientNode(ByteBufUtils.readItemStack((ByteBuf)buf), buf.readInt(), buf.readInt()));
            }
            return nodes;
        }

        public DataParameter<List<ClientNode>> func_187161_a(int id) {
            return null;
        }
    };
    public static final DataSerializer<List<ClientCraftingTask>> CLIENT_CRAFTING_TASK_SERIALIZER = new DataSerializer<List<ClientCraftingTask>>(){

        public void write(PacketBuffer buf, List<ClientCraftingTask> tasks) {
            buf.writeInt(tasks.size());
            for (ClientCraftingTask task : tasks) {
                int children = 0;
                for (ClientCraftingTask child = task.getChild(); child != null; child = child.getChild()) {
                    ++children;
                }
                this.writeTask(buf, task, children);
            }
        }

        private void writeTask(PacketBuffer buf, ClientCraftingTask task, int children) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)task.getStatus());
            buf.writeInt(children);
            buf.writeInt(task.getProgress());
            buf.writeInt(task.getOutputs().size());
            for (ItemStack output : task.getOutputs()) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)output);
            }
            buf.writeBoolean(task.getChild() != null);
            if (task.getChild() != null) {
                this.writeTask(buf, task.getChild(), children);
            }
        }

        public List<ClientCraftingTask> read(PacketBuffer buf) {
            int size = buf.readInt();
            ArrayList<ClientCraftingTask> tasks = new ArrayList<ClientCraftingTask>();
            for (int i = 0; i < size; ++i) {
                this.readTask(buf, i, 0, tasks);
            }
            return tasks;
        }

        private void readTask(PacketBuffer buf, int i, int depth, List<ClientCraftingTask> tasks) {
            String status = ByteBufUtils.readUTF8String((ByteBuf)buf);
            int children = buf.readInt();
            int progress = buf.readInt();
            int outputs = buf.readInt();
            for (int j = 0; j < outputs; ++j) {
                tasks.add(new ClientCraftingTask(ByteBufUtils.readItemStack((ByteBuf)buf), i, status, depth, children, progress));
            }
            if (buf.readBoolean()) {
                this.readTask(buf, i, depth + 1, tasks);
            }
        }

        public DataParameter<List<ClientCraftingTask>> func_187161_a(int id) {
            return null;
        }
    };
    public static final DataSerializer<FluidStack> FLUID_STACK_SERIALIZER = new DataSerializer<FluidStack>(){

        public void write(PacketBuffer buf, FluidStack value) {
            if (value == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)FluidRegistry.getFluidName((FluidStack)value));
                buf.writeInt(value.amount);
                buf.func_150786_a(value.tag);
            }
        }

        public FluidStack read(PacketBuffer buf) {
            try {
                if (buf.readBoolean()) {
                    return new FluidStack(FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)buf)), buf.readInt(), buf.func_150793_b());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        public DataParameter<FluidStack> func_187161_a(int id) {
            return null;
        }
    };
}

