/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile.externalstorage;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.api.storage.fluid.IFluidStorage;
import refinedstorage.apiimpl.storage.fluid.FluidUtils;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.externalstorage.TileExternalStorage;

public class FluidStorageExternal
implements IFluidStorage {
    private FluidStack cache;
    private TileExternalStorage externalStorage;
    private IFluidHandler handler;

    public FluidStorageExternal(TileExternalStorage externalStorage, IFluidHandler handler, IFluidTankProperties properties) {
        this.externalStorage = externalStorage;
        this.handler = handler;
    }

    public IFluidTankProperties getProperties() {
        return this.handler.getTankProperties().length != 0 ? this.handler.getTankProperties()[0] : null;
    }

    public FluidStack getContents() {
        return this.getProperties() == null ? null : this.getProperties().getContents();
    }

    @Override
    public List<FluidStack> getStacks() {
        return this.getContents() == null ? Collections.emptyList() : Collections.singletonList(this.getContents().copy());
    }

    @Override
    @Nullable
    public FluidStack insertFluid(@Nonnull FluidStack stack, int size, boolean simulate) {
        if (this.getProperties() != null && IFilterable.canTakeFluids(this.externalStorage.getFluidFilters(), this.externalStorage.getMode(), this.externalStorage.getCompare(), stack) && this.getProperties().canFillFluidType(stack)) {
            int filled = this.handler.fill(FluidUtils.copyStackWithSize(stack, size), !simulate);
            if (filled == size) {
                return null;
            }
            return FluidUtils.copyStackWithSize(stack, size - filled);
        }
        return FluidUtils.copyStackWithSize(stack, size);
    }

    @Override
    @Nullable
    public FluidStack extractFluid(@Nonnull FluidStack stack, int size, int flags) {
        FluidStack toDrain = FluidUtils.copyStackWithSize(stack, size);
        if (CompareUtils.compareStack(this.getContents(), toDrain, flags)) {
            return this.handler.drain(toDrain, true);
        }
        return null;
    }

    @Override
    public int getStored() {
        return this.getContents() != null ? this.getContents().amount : 0;
    }

    public int getCapacity() {
        return this.getProperties() != null ? this.getProperties().getCapacity() : 0;
    }

    @Override
    public int getPriority() {
        return this.externalStorage.getPriority();
    }

    public boolean updateCache() {
        FluidStack stack = this.getContents();
        if (this.cache == null) {
            this.cache = FluidUtils.copy(stack);
        } else if (!CompareUtils.compareStack(stack, this.cache, 6)) {
            this.cache = FluidUtils.copy(stack);
            return true;
        }
        return false;
    }

    public void updateCacheForcefully() {
        this.cache = FluidUtils.copy(this.getContents());
    }
}

