/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile.externalstorage;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.externalstorage.ItemStorageExternal;
import refinedstorage.tile.externalstorage.TileExternalStorage;

public class ItemStorageItemHandler
extends ItemStorageExternal {
    private TileExternalStorage externalStorage;
    private IItemHandler handler;

    public ItemStorageItemHandler(TileExternalStorage externalStorage, IItemHandler handler) {
        this.externalStorage = externalStorage;
        this.handler = handler;
    }

    @Override
    public int getCapacity() {
        return this.handler.getSlots() * 64;
    }

    @Override
    public List<ItemStack> getItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i) == null || this.handler.getStackInSlot(i).func_77973_b() == null) continue;
            items.add(this.handler.getStackInSlot(i).func_77946_l());
        }
        return items;
    }

    @Override
    public ItemStack insertItem(ItemStack stack, int size, boolean simulate) {
        if (IFilterable.canTake((IItemHandler)this.externalStorage.getItemFilters(), this.externalStorage.getMode(), this.externalStorage.getCompare(), stack)) {
            return ItemHandlerHelper.insertItem((IItemHandler)this.handler, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size), (boolean)simulate);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    @Override
    public ItemStack extractItem(ItemStack stack, int size, int flags) {
        int remaining = size;
        ItemStack received = null;
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack got;
            ItemStack slot = this.handler.getStackInSlot(i);
            if (slot == null || !CompareUtils.compareStack(slot, stack, flags) || (got = this.handler.extractItem(i, remaining, false)) == null) continue;
            if (received == null) {
                received = got;
            } else {
                received.field_77994_a += got.field_77994_a;
            }
            if ((remaining -= got.field_77994_a) == 0) break;
        }
        return received;
    }

    @Override
    public int getStored() {
        int size = 0;
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i) == null) continue;
            size += this.handler.getStackInSlot((int)i).field_77994_a;
        }
        return size;
    }

    @Override
    public int getPriority() {
        return this.externalStorage.getPriority();
    }
}

